{**
 * 2007-2017 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2017 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<div id="_desktop_cart">
  <div class="blockcart cart-preview js-sidebar-cart-trigger {if $cart.products_count > 0}active{else}inactive{/if}" data-refresh-url="{$refresh_url}">
    <div class="header">
        <a class="blockcart-link" rel="nofollow" href="{$cart_url}">
          <svg 
          xmlns="http://www.w3.org/2000/svg"
          xmlns:xlink="http://www.w3.org/1999/xlink"
          width="18px" height="20px">
          <path fill-rule="evenodd"  fill="rgb(0, 0, 0)"
          d="M17.089,19.362 C16.737,19.767 16.229,20.000 15.696,20.000 L2.382,20.000 C1.849,20.000 1.341,19.767 0.988,19.361 C0.635,18.954 0.472,18.412 0.538,17.875 L2.019,6.652 C2.135,5.708 2.929,4.997 3.865,4.997 L4.916,4.997 C5.002,2.753 6.812,0.951 9.039,0.951 C11.267,0.951 13.077,2.753 13.162,4.997 L14.214,4.997 C15.150,4.997 15.943,5.708 16.059,6.652 L17.541,17.875 C17.607,18.413 17.442,18.955 17.089,19.362 ZM9.039,1.950 C7.353,1.950 5.985,3.304 5.900,4.997 L12.179,4.997 C12.094,3.304 10.724,1.950 9.039,1.950 ZM15.083,6.776 C15.029,6.332 14.655,5.996 14.214,5.996 L3.865,5.996 C3.424,5.996 3.050,6.332 2.995,6.776 L1.514,17.999 C1.482,18.257 1.557,18.505 1.726,18.699 C1.894,18.893 2.128,19.000 2.382,19.000 L15.696,19.000 C15.951,19.000 16.183,18.893 16.352,18.699 C16.521,18.505 16.596,18.257 16.565,17.999 L15.083,6.776 Z"/>
          </svg>
          <span class="cart-products-count">{$cart.products_count}</span>
          <span class="hidden-lg-up mobile-cart-item-count">{$cart.products_count}</span>
        </a>
    </div>
    <div class="cart-dropdown js-cart-source hidden-xs-up">
      <div class="cart-dropdown-wrapper">
        <div class="cart-title">
          <p class="h4 text-center">{l s='Shopping Cart' d='Shop.Theme.Checkout'}</p>
        </div>
        {if $cart.products}
          <ul class="cart-items">
            {foreach from=$cart.products item=product}
              <li class="cart-product-line">{include 'module:ps_shoppingcart/ps_shoppingcart-product-line.tpl' product=$product}</li>
            {/foreach}
          </ul>
          <div class="cart-bottom">
            <div class="cart-subtotals">
              {foreach from=$cart.subtotals item="subtotal"}
                {if $subtotal}
                <div class="total-line {$subtotal.type}">
                  <span class="label">{$subtotal.label}</span>
                  <span class="value price">{$subtotal.value}</span>
                </div>
                {/if}
              {/foreach}
            </div>
            <hr>
            <div class="cart-total total-line">
              <span class="label">{$cart.totals.total.label}</span>
              <span class="value price price-total">{$cart.totals.total.value}</span>
            </div>
            <div class="cart-action">
              <div class="text-center">
                <a href="{$cart_url}" class="btn btn-primary">{l s='Proceed to checkout' d='Shop.Theme.Actions'}<i class="caret-right"></i></a>
              </div>
            </div>
          </div>
        {else}
          <div class="no-items">
            {l s='There are no more items in your cart' d='Shop.Theme.Checkout'}
          </div>
        {/if}
      </div>
    </div>

  </div>
</div>
