<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaPatron
*  @copyright  2017-2019 Presta Patron
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License 
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class Ppannouncements extends Module
{    

    public function __construct()
    {
        $this->name = 'ppannouncements';
        $this->tab = 'front_office_features';
        $this->version = '1.0.1';
        $this->author = 'Presta Patron';
        $this->need_instance = 1;

        $this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_); 
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('PP Announcement');
        $this->description = $this->l('Displays a announcement banner at the top of your store.');
        $this->module_key = '463b0e5b4204024ea87a250e57eaf377';
    }

    /**
     * Don't forget to create update methods if needed:
     * http://doc.prestashop.com/display/PS16/Enabling+the+Auto-Update
     */
    public function install()
    {

        $languages = Language::getLanguages(false);
        return parent::install() &&
            $this->registerHook('header') &&
            $this->registerHook('displayHeader');
    }

    public function uninstall()
    {
        $languages = Language::getLanguages(false);

        return parent::uninstall();
    }

    /**
     * Load the configuration form
     */
    public function getContent()
    {
        /**
         * If values have been submitted in the form, process.
         */
        if (((bool)Tools::isSubmit('submitPPAnnouncement')) == true) {
            $this->postProcess();
        }

        return $this->renderForm();
        
    }

    /**
	 * Create the form that will be displayed in the configuration of your module.
	 */
    protected function renderForm()
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $this->context->language->id;
        $helper->module = $this;
       
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitPPAnnouncement';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false)
            .'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFormValues(), /* Add values for your inputs */
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm(array($this->getConfigForm(), $this->getDesignForm()));
    }

    /**
     * Create the structure of your form.
     */
    protected function getConfigForm()
    {

    	$options = array(
		  array(
		    'id_option' => 1,  
		    'name' => 'Simple' 
		  ),
		  array(
		    'id_option' => 2,
		    'name' => 'Countdown'
		  ),
		  array(
		    'id_option' => 3,
		    'name' => 'Countdown with Coupon'
		  ),
		);


        return array(

            'form' => array(
                'legend' => array(
                'title' => $this->l('Announcement Settings'),
                'icon' => 'icon-cogs',
                ),
                'input' => array(
	        	array(
                    'type' => 'switch',
                    'label' => $this->l('Add Announcement:'),
                    'desc' => $this->l('Enable to add Announcement bar'),
                    'name' => 'ENABLE_ANNOUNCEMENT',
                    'values' => array(
                        array(
                            'id' => 'active_on',
                            'value' => 1,
                            'label' => $this->l('Enabled')
                        ),
                        array(
                            'id' => 'active_off',
                            'value' => 0,
                            'label' => $this->l('Disabled')
                        )
                    ),
                ),
                array(
				  'type' => 'select',
				  'label' => $this->l('Announcement Type:'),  
				  'desc' => $this->l('Choose an announcement type'), 
				  'name' => 'ANNOUNCEMENT_TYPE', 
				  'required' => true, 
				  'options' => array(
				    'query' => $options,  
				    'id' => 'id_option',  
				    'name' => 'name',   
				  )				  
				),				
	        	array(
	                'type' => 'date',
	                'label' => $this->l('Start Date:'),
	                'name' => 'ANNOUNCEMENT_START_DATE',
                    'desc' => $this->l('Select Announcement start date'),
	                'size' => 10,
	            ),

	            array(
	                'type' => 'date',
	                'label' => $this->l('End Date:'),
	                'name' => 'ANNOUNCEMENT_END_DATE',
                    'desc' => $this->l('Select Announcement end date'),
	                'size' => 10,	               
	            ),

	            array(
	                'type' => 'text',
	                'label' => $this->l('Coupon Code:'),
                    'desc' => $this->l('Enter the Coupon code here'),
	                'name' => 'ANNOUNCEMENT_CODE',
	                'size' => 20,	
	                'lang' => true,	
	            ),


	            array(
	                'type' => 'text',
	                'label' => $this->l('Announcement Text'),
	                'desc' => $this->l('Enter the Announcement Text here'),
	                'name' => 'ANNOUNCEMENT_TEXT',
	                'size' => 20,
	                'required' => true,	  
	                'lang' => true,	              
	            ),
	            array(
	                'type' => 'text',
	                'label' => $this->l('Announcement Link'),
	                'desc' => $this->l('Enter the link of Announcement, if any'),
	                'name' => 'ANNOUNCEMENT_LINK',
	                'size' => 20,
	                'lang' => true,	                
	            ),

	            array(
	                'type' => 'text',
	                'label' => $this->l('Announcement Link Text'),
	                'desc' => $this->l('Enter the text for  link of Announcement, if any'),
	                'name' => 'ANNOUNCEMENT_LINK_TEXT',
	                'size' => 20,
	                'lang' => true,		                
	            ),

                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                ),
            ),



        );
    }


    /**
     * Create the structure of your form.
     */
    protected function getDesignForm() {
    	return array(

            'form' => array(
            	'legend' => array(
	        'title' => $this->l('Design Settings'),
	        ),
	        'input' => array(
	        	
	            array(
	                'type' => 'color',
	                'label' => $this->l('Banner Background'),
	                'name' => 'BANNER_BG_COLOR',
	                'size' => 20, 
	            ),

	            array(
	                'type' => 'color',
	                'label' => $this->l('Banner Text Color'),
	                'name' => 'TEXT_COLOR',
	                'size' => 20,
	            ),

	            array(
	                'type' => 'color',
	                'label' => $this->l('Button Background Color'),
	                'name' => 'BUTTON_BG_COLOR',
	                'size' => 20, 
	            ),
	            array(
	                'type' => 'color',
	                'label' => $this->l('Button Text Color'),
	                'name' => 'BUTTON_TEXT_COLOR',
	                'size' => 20,   
	            ),

	        ),
	        'submit' => array(
	            'title' => $this->l('Save'),
	            'class' => 'btn btn-default pull-right'
	        )


            ),
        );

    }

    /**
     * Set values for the inputs.
     */
    protected function getConfigFormValues()
    {

        $languages = Language::getLanguages(false);
        $values = array();

        foreach ($languages as $lang)
        {
            $values['ENABLE_ANNOUNCEMENT'] = Tools::getValue('ENABLE_ANNOUNCEMENT');

            $values['ANNOUNCEMENT_TYPE'] = Tools::getValue('ANNOUNCEMENT_TYPE');

            $values['ANNOUNCEMENT_CODE'][$lang['id_lang']] = Tools::getValue('ANNOUNCEMENT_CODE_'.$lang['id_lang']);

            $values['ANNOUNCEMENT_START_DATE'] = Tools::getValue('ANNOUNCEMENT_START_DATE');

            $values['ANNOUNCEMENT_END_DATE'] = Tools::getValue('ANNOUNCEMENT_END_DATE');

            $values['ANNOUNCEMENT_LINK'][$lang['id_lang']] = Tools::getValue('ANNOUNCEMENT_LINK_'.$lang['id_lang']);

            $values['ANNOUNCEMENT_TEXT'][$lang['id_lang']] = Tools::getValue('ANNOUNCEMENT_TEXT_'.$lang['id_lang']);

            $values['ANNOUNCEMENT_LINK_TEXT'][$lang['id_lang']] = Tools::getValue('ANNOUNCEMENT_LINK_TEXT_'.$lang['id_lang']);

            $values['BANNER_BG_COLOR'] = Tools::getValue('BANNER_BG_COLOR');

            $values['TEXT_COLOR'] = Tools::getValue('TEXT_COLOR');


            $values['BUTTON_BG_COLOR'] = Tools::getValue('BUTTON_BG_COLOR');


            $values['BUTTON_TEXT_COLOR'] = Tools::getValue('BUTTON_TEXT_COLOR');
        }
        return $values;

    }

    /**
     * Save form data.
     */
    protected function postProcess()
    {
        $form_values = $this->getConfigFormValues();

       
        Configuration::updateValue('ENABLE_ANNOUNCEMENT', $form_values['ENABLE_ANNOUNCEMENT'] );
      
       
        Configuration::updateValue('ANNOUNCEMENT_TYPE', $form_values['ANNOUNCEMENT_TYPE']);
     

        foreach ($form_values['ANNOUNCEMENT_CODE'] as $k=>$key) {  
            Configuration::updateValue('ANNOUNCEMENT_CODE_'.$k, $key);
        }

       
        Configuration::updateValue('ANNOUNCEMENT_START_DATE', $form_values['ANNOUNCEMENT_START_DATE']);


        Configuration::updateValue('ANNOUNCEMENT_END_DATE', $form_values['ANNOUNCEMENT_END_DATE']);
        


        foreach ($form_values['ANNOUNCEMENT_LINK'] as $k=>$key) {  
            Configuration::updateValue('ANNOUNCEMENT_LINK_'.$k, $key);
        }


        foreach ($form_values['ANNOUNCEMENT_TEXT'] as $k=>$key) {  
            Configuration::updateValue('ANNOUNCEMENT_TEXT_'.$k, $key);
        }


        foreach ($form_values['ANNOUNCEMENT_LINK_TEXT'] as $k=>$key) {  
            Configuration::updateValue('ANNOUNCEMENT_LINK_TEXT_'.$k, $key);
        }

       Configuration::updateValue('BANNER_BG_COLOR', $form_values['BANNER_BG_COLOR']);
       Configuration::updateValue('TEXT_COLOR', $form_values['TEXT_COLOR']);
       Configuration::updateValue('BUTTON_BG_COLOR', $form_values['BUTTON_BG_COLOR']);
       Configuration::updateValue('BUTTON_TEXT_COLOR' , $form_values['BUTTON_TEXT_COLOR']);
       


    }

    /**
    * Add the CSS & JavaScript files you want to be loaded in the BO.
    */
    public function hookBackOfficeHeader()
    {
        if (Tools::getValue('module_name') == $this->name) {
            $this->context->controller->addJS($this->_path.'views/js/back.js');
            $this->context->controller->addCSS($this->_path.'views/css/back.css');
        }
    }

    /**
     * Add the CSS & JavaScript files you want to be added on the FO.
     */
    public function hookHeader()
    {
        $this->context->controller->addJS($this->_path.'/views/js/front.js');
        $this->context->controller->addCSS($this->_path.'/views/css/front.css');
    }

   public function hookDisplayHeader($params) {
    	$this->smarty->assign(array(

    		'enable_announcement' => Configuration::get('ENABLE_ANNOUNCEMENT'),
    		'announcement_type' => Configuration::get('ANNOUNCEMENT_TYPE'),	

			'announcement_code' => Configuration::get('ANNOUNCEMENT_CODE_'.$this->context->language->id),		
			'announcement_start_date' => Configuration::get('ANNOUNCEMENT_START_DATE'),	
			'announcement_end_date' => Configuration::get('ANNOUNCEMENT_END_DATE'),	
			'announcement_link' => Configuration::get('ANNOUNCEMENT_LINK_'.$this->context->language->id),
			'announcement_text' => Configuration::get('ANNOUNCEMENT_TEXT_'.$this->context->language->id),
			'announcement_link_text' => Configuration::get('ANNOUNCEMENT_LINK_TEXT_'.$this->context->language->id),


			'banner_bg_color' => Configuration::get('BANNER_BG_COLOR'),	
			'text_color' => Configuration::get('TEXT_COLOR'),
			'button_bg_color' => Configuration::get('BUTTON_BG_COLOR'),
			'button_text_color' => Configuration::get('BUTTON_TEXT_COLOR'),

			
		));

        $this->context->controller->addCSS($this->_path.'views/css/ppannouncements.css');

        $this->context->controller->addJS($this->_path.'views/js/ppannouncements.js');

        $this->context->controller->addJS($this->_path.'views/js/countdown.js');


        return $this->display(__FILE__, '/views/templates/hook/ppannouncment-front.tpl');
    }

}