{*
* 2022 Anvanto
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
*
*  @author    Anvanto <anvantoco@gmail.com>
*  @copyright 2022 Anvanto
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*}

{extends file="helpers/form/form.tpl"}

{block name="input"}

	{if $input.type == 'inputProducts'}
		<div class="col-lg-12">
			<div id="{if isset($input.id)}{$input.id|escape:'html':'utf-8'}{else}{$input.name|escape:'html':'utf-8'}{/if}"
				class="{if isset($input.class)}{$input.class|escape:'html':'utf-8'}{/if} {* fixed-width-xl *}"
			>
			{foreach from=$fields_value[$input.name] item=item name=fo}
			<div class="js-an_sizeguide_products-line an_sizeguide_products-line"><input type="hidden" name="productIds[]" value="{$item.id_product}" />{* <img src="'+img+'" />*}<div class="label">{$item.name} (ref: {$item.reference}) <i class="material-icons delete js-an_sizeguide_products-remove">delete</i></div></div>
			{/foreach}
			</div>
		</div>
	{elseif  $input.type == 'number'}	
	<input type="number"
		id="{if isset($input.id)}{$input.id}{else}{$input.name}{/if}"
		name="{$input.name}"
		class="form-control {if isset($input.class)} {$input.class} {/if}"
		onkeyup="return (function (el, e) {
			if (e.keyCode == 8) return true;
			jQuery(el).val((parseInt(jQuery(el).val()) || 0));
			if (jQuery(el).val() < (parseInt(jQuery(el).attr('min')) || 0)) {
				jQuery(el).val((parseInt(jQuery(el).attr('min')) || 0));
			} else if (jQuery(el).val() > (parseInt(jQuery(el).attr('max')) || 0)) {
				jQuery(el).val((parseInt(jQuery(el).attr('max')) || 0));
			}
		})(this, event);"
		value="{$fields_value[$input.name]|escape:'html':'UTF-8'}"
		{if isset($input.size)} size="{$input.size}"{/if}
		{if isset($input.maxchar) && $input.maxchar} data-maxchar="{$input.maxchar|intval}"{/if}
		{if isset($input.maxlength) && $input.maxlength} maxlength="{$input.maxlength|intval}"{/if}
		{if isset($input.readonly) && $input.readonly} readonly="readonly"{/if}
		{if isset($input.disabled) && $input.disabled} disabled="disabled"{/if}
		{if isset($input.autocomplete) && !$input.autocomplete} autocomplete="off"{/if}
		{if isset($input.required) && $input.required} required="required" {/if}
		{if isset($input.max)} max="{$input.max|intval}"{/if}
		{if isset($input.min)} min="{$input.min|intval}"{/if}
		{if isset($input.placeholder) && $input.placeholder} placeholder="{$input.placeholder}"{/if} />
		{if isset($input.suffix)}
		<span class="input-group-addon">
			{$input.suffix}
		</span>
		{/if}	
	{elseif $input.type == 'html'}
		{if isset($input.html_content)}
			{if $input.html_content == 'hr'}
			<hr />
			{else}
			{$input.html_content}
			{/if}
		{else}
			{$input.name|escape:'htmlall':'UTF-8'}
		{/if}
	{else}	
		{$smarty.block.parent}
    {/if}
{/block}