﻿<?php
/**
 * 2021 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2021 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */


class AdminProducttabsSettingsController extends ModuleAdminController
{
    protected $_module = null;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->display = 'view';
 
        $this->name = 'AdminProducttabsSettingsController';
        
        parent::__construct();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
    } 

    public function initToolBarTitle()
    {
        $this->toolbar_title[] = $this->module->l('Product Tabs: Settings');
    }

    public function initHeader()
    {
        parent::initHeader();

        $id_lang = $this->context->language->id;
        $link = $this->context->link;
        $tabs = &$this->context->smarty->tpl_vars['tabs']->value;

        foreach ($tabs as &$tab0) {
            if ($tab0['class_name'] == 'IMPROVE') {
                foreach ($tab0['sub_tabs'] as &$tab1) {
                    if ($tab1['class_name'] == 'AdminParentModulesSf') {
                        
                        foreach ($tab1['sub_tabs'] as &$tab2) {
                            if ($tab2['class_name'] == 'AdminProducttabsSettings') {
                                $sub_tabs = &$tab2['sub_tabs'];

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminProductTabs'));
                                $tab['current'] = false;
                                $tab['href'] = $link->getAdminLink('AdminProductTabs');
                                $tab['active'] = true;
                                $tab['name'] = $this->l('Tabs');
                                $sub_tabs[] = $tab;  

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminProducttabsSettings'));
                                $tab['current'] = true;
                                $tab['href'] = $link->getAdminLink('AdminProducttabsSettings');
                                $tab['active'] = true;
                                $tab['name'] = $this->l('Settings');
                                $sub_tabs[] = $tab;

                                break;
                            }
                        }
                        break;
                    }
                }
                break;
            }
        }
    }    
    
    public function initContent()
    {
        $this->context->smarty->assign('current_tab_level', 3);

        return parent::initContent();
    }    
    /**
     * Create the structure of your form.
     */
    protected function getSettingsForm()
    {
        $form['form']['legend'] = [
            'title' => $this->l('Product Tabs: Settings'),
        ];

        $form['form']['submit'] = [
            'name' => 'save',
            'title' => $this->l('Save'),
        ];

        $form['form']['input'][] = [
            'type' => 'radio',
            'label' => 'View type',
            'name' => an_productextratabs::PREFIX . 'view_type',
            'class' => 'an-sz-type-view',
            'values' => [
                [
                    'id' => 'view_type_tabs',
                    'value' => '0',
                    'label' => $this->module->l('Tabs'),
                ], 
                [
                    'id' => 'view_type_blocks',
                    'value' => '1',
                    'label' => $this->module->l('Blocks')
                ], 
                [
                    'id' => 'view_type_accordion',
                    'value' => '2',
                    'label' => $this->module->l('Accordion')
                ]
            ]
        ];

        return $form;
    }

    public function renderView()
    {
        $languages = $this->context->controller->getLanguages();
  
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->name_controller = $this->name;
        $helper->submit_action = $this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminProducttabsSettings', false);
        $helper->token = Tools::getAdminTokenLite('AdminProducttabsSettings');
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->tpl_vars = [
            'uri' => $this->module->getPathUri(),
            'languages' => $languages,
            'id_language' => $this->context->language->id
        ];

        $form = $this->getSettingsForm();

        foreach ($form['form']['input'] as $input){
            $helper->tpl_vars['fields_value'][$input['name']] = Configuration::get($input['name']);
        }
            
        return $helper->generateForm([$form]) . $this->module->topPromo();        
    }

    public function postProcess()
    {    
        $form = $this->getSettingsForm();
        
        if (Tools::isSubmit($form['form']['submit']['name'])) {

            $languages = Language::getLanguages(false);
            
            foreach ($form['form']['input'] as $input){

                $html = false;
                
                if (isset($input['html']) && $input['html']){
                    $html = true;
                }
                
                Configuration::updateValue($input['name'], Tools::getValue($input['name']), $html); 
            }

            $currentIndex = $this->context->link->getAdminLink('AdminProducttabsSettings', false);
            $token = Tools::getAdminTokenLite('AdminProducttabsSettings'); 
            
            Tools::redirectAdmin($currentIndex . '&token=' . $token . '&conf=4');
        }
        return true;
    }
}
