<?php
/**
* 2022 Anvanto
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
*
*  @author    Anvanto <anvantoco@gmail.com>
*  @copyright 2022 Anvanto
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

class anProductTabs extends ObjectModel
{
    /**
     * @var int
     */
    public $id_tab;
    /**
     * @var int
     */
    public $id;
    /**
     * @var int
     */
    public $active = 1;
    public $combinations = 0;
    public $relation = 0;
    public $position = 0;
    
    public $tab_content;
    public $tab_name;

    /**
     * @var array
     */

    public static $definition = [
        'table' => 'an_productextratabs',
        'primary' => 'id_tab',
        'multilang' => true,
        'fields' => [
            'active' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'combinations' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],

            'relation' => ['type' =>self::TYPE_INT],
            
            'position' => ['type' =>self::TYPE_INT ],
            
            'tab_content' => ['type' =>self::TYPE_HTML,'lang' => true ],
            'tab_name' => ['type' =>self::TYPE_HTML,'lang' => true ],
        ],
    ];

    public const fileJsonTabsDefault = _PS_MODULE_DIR_ . 'an_productextratabs/tabs_default.json';
    /**
     * Formula constructor.
     *
     * @param null $id
     */
    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function getTabsByIdProduct($id_product)
    {
        $context = Context::getContext();
        $cats = product::getProductCategories($id_product);

        $sql = '
        SELECT * FROM `' . _DB_PREFIX_ . 'an_productextratabs_relations` szwr, `' . _DB_PREFIX_ . 'an_productextratabs` sw
        LEFT JOIN `' . _DB_PREFIX_ . 'an_productextratabs_lang` sl 
            ON (sw.`id_tab` = sl.`id_tab`
            AND sl.`id_lang` = ' . (int) $context->language->id . ')
        WHERE sw.`active`=1
            AND sw.`id_tab` = szwr.`id_tab` AND sw.`relation` = szwr.`type`
            AND ((szwr.`type` = 1 AND szwr.`id_type` IN (' . implode(', ', $cats) . ')   )
                OR (szwr.`type` = 2 AND szwr.`id_type` = '.(int) $id_product.')
                OR (szwr.`type` = 0 AND szwr.`id_type` = 0)
                )
        ';    
        
        if (Shop::isFeatureActive()) {
            $sql .= ' AND sw.`id_tab` IN (
                SELECT sa.`id_tab`
                FROM `' . _DB_PREFIX_ . 'an_productextratabs_shop` sa
                WHERE sa.id_shop IN (' . implode(', ', Shop::getContextListShopID()) . ')
            )';
        }
       
        $sql .= ' GROUP BY sw.`id_tab`';
        $sql .= ' ORDER BY sw.`position`';
       
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

        return $result;
    }

    public static function getProducsByIdTabs($id_tab = 0)
    {
        if (!$id_tab){
            return [];
        }
        
        $sql = '
        SELECT  *, p.*
        FROM `' . _DB_PREFIX_ . 'an_productextratabs_relations` awl
        
        LEFT JOIN `' . _DB_PREFIX_ . 'product` p
            ON (p.`id_product` = awl.`id_type`)
        
        LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl
            ON (p.`id_product` = pl.`id_product`
            AND pl.`id_lang` = ' . (int) Context::getContext()->language->id . Shop::addSqlRestrictionOnLang('pl') . ')        
        
        WHERE awl.`id_tab` = ' . (int) $id_tab . '  AND awl.`type`="2" ';
        
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql, true, false);

        return Product::getProductsProperties(Context::getContext()->language->id, $result);
    } 

    public static function getRelationCategories($id_tab = 0)
    {
        if (!$id_tab){
            return [];
        }
        
        $sql = '
        SELECT `id_type`
        FROM `' . _DB_PREFIX_ . 'an_productextratabs_relations` awl        
        WHERE awl.`id_tab` = ' . (int) $id_tab . ' AND awl.`type`="1"  ';
        
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql, true, false);
        
        $cats = [];
        if ($result) {
            foreach ($result as $item){
                $cats[] = $item['id_type'];
            }
        }
        
        return $cats;        
    }  

    public static function getAllTabs()
    {
        $context = Context::getContext();

        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'an_productextratabs` sw';

        if (Shop::isFeatureActive()) {
            $sql .= ' AND sw.`id_tab` IN (
                SELECT sa.`id_tab`
                FROM `' . _DB_PREFIX_ . 'an_productextratabs_shop` sa
                WHERE sa.id_shop IN (' . implode(', ', Shop::getContextListShopID()) . ')
            )';
        }

        $tabs = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

        foreach ($tabs as $key => $tab){
            $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'an_productextratabs_relations` WHERE `id_tab` = ' . (int) $tab['id_tab'] . '';
            $res = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
            $tabs[$key]['relations'] = $res;

            $sql_lang = 'SELECT * FROM `' . _DB_PREFIX_ . 'an_productextratabs_lang` WHERE `id_tab` = ' . (int) $tab['id_tab'] . '';
            $res_lang = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql_lang);
            $tabs[$key]['languages'] = $res_lang;
        }

        return $tabs;
    } 
    
    public static function importJsonTabsDefault()
    {
        if (!(Tools::file_exists_no_cache(self::fileJsonTabsDefault))){
            return;
        }

        $data = json_decode(Tools::file_get_contents(self::fileJsonTabsDefault), true);
        $context = Context::getContext();
        $languages = Language::getLanguages();

        if (!($data)){
            return false;
        }

        foreach ($data as $item){
            $tabObj = new anProductTabs();
            
            $tabObj->active = 1;
            $tabObj->position = 0;
            $tabObj->combinations = 0;
            $tabObj->relation = 0;
                    
            foreach ($languages as $language) {
                $tabObj->tab_content[$language['id_lang']] = $item['tab_content'];
                $tabObj->tab_name[$language['id_lang']] = $item['tab_name'];
            }

            $tabObj->save();

            $sql = 'INSERT INTO `'._DB_PREFIX_.'an_productextratabs_relations`  (`id_tab`, `id_type`, `type`) 
            VALUES ("'.(int) $tabObj->id.'", "0", "0" )';
            Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute($sql);  
        }
    }    

    public static function importJsonAllTabs($data)
    {
        if (!($data)){
            return false;
        }
            foreach ($data as $item){
        
            $tabObj = new anProductTabs();
            
            $tabObj->active = $item['active'];
            $tabObj->position = $item['position'];
            $tabObj->combinations = $item['combinations'];
            $tabObj->relation = $item['relation'];
                    
            foreach ($item['languages'] as $key => $tab) {
                $tabObj->tab_content[$tab['id_lang']] = $tab['tab_content'];
                $tabObj->tab_name[$tab['id_lang']] = $tab['tab_name'];
            }

            $tabObj->save();

            foreach ($item['relations'] as $key => $tab){

                $sql = 'INSERT INTO `'._DB_PREFIX_.'an_productextratabs_relations`  (`id_tab`, `id_type`, `type`) 
                VALUES ("'.(int) $tabObj->id.'","'.(int) $tab['id_type'].'","'.(int) $tab['type'].'" )';
                Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute($sql);
            } 
        }
    }   
}