<?php
/**
* 2022 Anvanto
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
*
*  @author    Anvanto <anvantoco@gmail.com>
*  @copyright 2022 Anvanto
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

require_once _PS_MODULE_DIR_ . 'an_productextratabs/classes/an_combinations.php';
require_once _PS_MODULE_DIR_ . 'an_productextratabs/classes/anProductTabs.php';

class an_productextratabs extends Module implements WidgetInterface
{
    const PREFIX = 'an_pt_';
    
    protected $_tabs = [
 
        [
            'class_name' => 'AdminProductTabs',
            'parent' => 'AdminParentModulesSf',
            'name' => 'Product Tabs: Tabs',
            'active' => 0
        ], 
        
        [
            'class_name' => 'AdminProducttabsSettings',
            'parent' => 'AdminParentModulesSf',
            'name' => 'Product Tabs: Settings',
            'active' => 0
        ], 
           
    ];    

    public function __construct()
    {
        $this->name = 'an_productextratabs';
        $this->tab = 'others';
        $this->version = '3.0.1';
        $this->author = 'Anvanto';
        $this->need_instance = 0;

        $this->bootstrap = true;
        $this->module_key = '3b466206aa8f1f635aaa18f9c1523fd8';
        $this->addons_product_id = '26048';

        parent::__construct();

        $this->displayName = $this->l('Product Extra Tabs Premium');
        $this->description = $this->l('The module creates additional description tabs with any format of content.');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall the module?');

        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);
    }

    /**
     * @return bool
     */

    public function install()
    {
        $sql = include _PS_MODULE_DIR_ . $this->name . '/sql/install.php';
        foreach ($sql as $_sql) {
            Db::getInstance()->Execute($_sql);
        } 
            
        $languages = Language::getLanguages();
        foreach ($this->_tabs as $tab) {
            $_tab = new Tab();
            $_tab->active = $tab['active'];
            $_tab->class_name = $tab['class_name'];
            $_tab->id_parent = Tab::getIdFromClassName($tab['parent']);
            if (empty($_tab->id_parent)) {
                $_tab->id_parent = 0;
            }

            $_tab->module = $this->name;
            foreach ($languages as $language) {
                $_tab->name[$language['id_lang']] = $this->l($tab['name']);
            }

            $_tab->add();
        }

        anProductTabs::importJsonTabsDefault();
        
        return parent::install()
            && $this->registerHook('displayHeader')
            && $this->registerHook('displayProductExtraContent');
    }

    public function uninstall()
    {
         $sql = include _PS_MODULE_DIR_ . $this->name .  '/sql/uninstall.php';
        foreach ($sql as $_sql) {
            Db::getInstance()->Execute($_sql);
        }     
        
        foreach ($this->_tabs as $tab) {
            $_tab_id = Tab::getIdFromClassName($tab['class_name']);
            $_tab = new Tab($_tab_id);
            $_tab->delete();
        }        
    
        return parent::uninstall();
    }

    /**
     * @return bool
     */

    public function renderWidget($hookName, array $params)
    { 
        return; 
    }

    public function getWidgetVariables($hookName, array $params)
    {            
        $widgets = [];
        return $widgets;
    }
    
    public function getContent()
    {
        Tools::redirectAdmin($this->context->link->getAdminLink('AdminProductTabs'));
    }

    public function hookDisplayHeader()
    {
        if ($this->context->controller instanceof ProductController) {
            $this->context->controller->addJquery();
            
            $this->context->controller->registerStylesheet(
                $this->name . "_css",
                'modules/' . $this->name . '/views/css/front.css',
                ['server' => 'local', 'priority' => 150]
            );
            
            switch (Configuration::get(an_productextratabs::PREFIX . 'view_type')){
                case 0:
                    return;
                    break; 

                case 1:
                    $jsFile = 'block';
                    break;        

                case 2:
                    $jsFile = 'accordion';
                    break;    
                    
            } 

            $this->context->controller->registerJavascript(
                $this->name . "_js",
                'modules/' . $this->name . '/views/js/'.$jsFile.'.js',
                ['server' => 'local', 'priority' => 150]
            );
        }
    }

    public function getCombinationsView($id_product)
    {
        $productObj = new Product($id_product, false, (int)$this->context->language->id);
        $attributeCombinations = $productObj->getAttributeCombinations((int)$this->context->language->id);
        $productData = anComb::attributeCombinationForSelect($attributeCombinations, $productObj);

        $config = array(
            'display_image'          => true,
            'display_reference'      => true,
            'display_attributes'     => true,
            'combine_attributes'     => true,
            'display_availability'   => false,
            'display_quantity'       => false,
            'display_price'          => true,
            'display_add_to_cart'    => true,
            'display_field_quantity' => true,
        );

        $this->context->smarty->assign([                
            'cart' => $this->context->link->getPageLink('cart'),
            'token' => Tools::getToken(false),
            
            'product_id' => (int) $productObj->id,

            'config' => $config,
            'productData' => $productData,
        ]);

        return $this->display(__FILE__, 'views/templates/hook/combinations.tpl');
    }

    public function hookDisplayProductExtraContent($params)
    {
        
        $id_product = $params['product']->id;

        $myTabs = anProductTabs::getTabsByIdProduct($id_product);

        $tabs = [];    
        
        foreach ($myTabs as $tabItem){
            $tab = new PrestaShop\PrestaShop\Core\Product\ProductExtraContent();

            $this->smarty->assign(self::PREFIX .'tab', $tabItem['tab_content']);
            
            $tplCombContent = '';

            if($tabItem['combinations'] == 1){
                $tplCombContent = $this->getCombinationsView($id_product);
            }

            $this->smarty->assign(self::PREFIX .'comb', $tplCombContent);

            $tab->setTitle($tabItem['tab_name'])
                ->setContent($this->display(__FILE__, '/views/templates/front/tab_content.tpl'));
            $tabs[] = $tab;
        }

        return $tabs;
    }

    public function topPromo()
    {        
        $this->context->smarty->assign('theme', $this->getThemeInfo());
        return $this->display(__FILE__, 'views/templates/admin/top.tpl');
    }
    
    public function getThemeInfo()
    {
        $theme = [];
        $themeFileJson = _PS_THEME_DIR_.'/config/theme.json';
        if (Tools::file_exists_no_cache($themeFileJson)) {
            $theme = (array)json_decode(Tools::file_get_contents($themeFileJson), 1);            
        }

        if (!isset($theme['url_contact_us']) || $theme['url_contact_us'] == ''){
            
            $urlContactUs = 'https://addons.prestashop.com/contact-form.php';

            if (isset($theme['addons_id']) && $theme['addons_id'] != ''){
                $urlContactUs .= '?id_product=' .$theme['addons_id'];
            } elseif (isset($this->url_contact_us) && $this->url_contact_us != ''){
                $urlContactUs = $this->url_contact_us;
            } elseif (isset($this->addons_product_id) && $this->addons_product_id != ''){
                $urlContactUs .= '?id_product=' .$this->addons_product_id;
            }
            
            $theme['url_contact_us'] = $urlContactUs;
        }
        
        if (!isset($theme['url_rate']) || $theme['url_rate'] == ''){
            
            $urlRate = 'https://addons.prestashop.com/ratings.php';

            if (isset($theme['addons_id']) && $theme['addons_id'] != ''){
                $urlRate .= '?id_product=' .$theme['addons_id'];
            } elseif (isset($this->url_rate) && $this->url_rate != ''){
                $urlRate = $this->url_rate;
            } elseif (isset($this->addons_product_id) && $this->addons_product_id != ''){
                $urlRate .= '?id_product=' .$this->addons_product_id;
            }
            
            $theme['url_rate'] = $urlRate;
        }        
        return $theme;
    }
}
