{*
* 2022 Anvanto
*
* NOTICE OF LICENSE
*
* This file is not open source! Each license that you purchased is only available for 1 wesite only.
* If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
* You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
*
*  @author Anvanto <anvantoco@gmail.com>
*  @copyright  2022 Anvanto
*  @license    Valid for 1 website (or project) for each purchase of license
*  International Registered Trademark & Property of Anvanto
*}

{extends file="helpers/form/form.tpl"}

{block name="input"}
	{if $input.type == 'number'}	
	<input type="number"
		id="{if isset($input.id)}{$input.id}{else}{$input.name}{/if}"
		name="{$input.name}"
		class="form-control {if isset($input.class)} {$input.class} {/if}"
		onkeyup="return (function (el, e) {
			if (e.keyCode == 8) return true;
			jQuery(el).val((parseInt(jQuery(el).val()) || 0));
			if (jQuery(el).val() < (parseInt(jQuery(el).attr('min')) || 0)) {
				jQuery(el).val((parseInt(jQuery(el).attr('min')) || 0));
			} else if (jQuery(el).val() > (parseInt(jQuery(el).attr('max')) || 0)) {
				jQuery(el).val((parseInt(jQuery(el).attr('max')) || 0));
			}
		})(this, event);"
		value="{$fields_value[$input.name]|escape:'html':'UTF-8'}"
		{if isset($input.size)} size="{$input.size}"{/if}
		{if isset($input.maxchar) && $input.maxchar} data-maxchar="{$input.maxchar|intval}"{/if}
		{if isset($input.maxlength) && $input.maxlength} maxlength="{$input.maxlength|intval}"{/if}
		{if isset($input.readonly) && $input.readonly} readonly="readonly"{/if}
		{if isset($input.disabled) && $input.disabled} disabled="disabled"{/if}
		{if isset($input.autocomplete) && !$input.autocomplete} autocomplete="off"{/if}
		{if isset($input.required) && $input.required} required="required" {/if}
		{if isset($input.max)} max="{$input.max|intval}"{/if}
		{if isset($input.min)} min="{$input.min|intval}"{/if}
		{if isset($input.placeholder) && $input.placeholder} placeholder="{$input.placeholder}"{/if} />
		{if isset($input.suffix)}
		<span class="input-group-addon">
			{$input.suffix}
		</span>
		{/if}	
	{elseif $input.type == 'file_lang'}
	
		{foreach from=$languages item=language}
			{if $languages|count > 1}
				<div class="translatable-field lang-{$language.id_lang}" {if $language.id_lang != $defaultFormLanguage}style="display:none"{/if}>
			{/if}
			<div class="form-group-image">
				{if isset($fields_value[$input.name][$language.id_lang]) && $fields_value[$input.name][$language.id_lang] != ''}
				<div class="form-group">
					<div id="{$input.name}-{$language.id_lang}-images-thumbnails" class="col-lg-12">
						<img src="../modules/an_homeproducts/img/{$fields_value[$input.name][$language.id_lang]}" 
						class="img-thumbnail"
						style="max-height: 150px; max-width: 150px;"
						/>
					</div>
				</div>
				<div class="form-group">
					<div id="{$input.name}-{$language.id_lang}-images-delete" class="col-lg-12">
						<span id="{$input.name}_{$language.id_lang}-deletebutton" type="button" name="submitDeleteAttachments" 
						class="btn btn-default an-image-deletebutton an-image-deletebutton-{$language.id_lang}">
							<i class="icon-trash"></i> {l s='Delete' mod='an_homeproducts'}
						</span>
					</div>
				</div>
				{/if}
			</div>
			<div class="form-group">
				<div class="col-lg-9">
					<input id="{$input.name}_{$language.id_lang}" type="file" name="{$input.name}_{$language.id_lang}" class="hide" />
					<div class="dummyfile input-group">
						<span class="input-group-addon"><i class="icon-file"></i></span>
						<input id="{$input.name}_{$language.id_lang}-name" type="text" class="disabled" name="filename" readonly />
						<span class="input-group-btn">
							<button id="{$input.name}_{$language.id_lang}-selectbutton" type="button" name="submitAddAttachments" class="btn btn-default">
								<i class="icon-folder-open"></i> {l s='Choose a file' mod='an_homeproducts'}
							</button>								
						</span>
					</div>
					
				</div>
				{if $languages|count > 1}
					<div class="col-lg-2">
						<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
							{$language.iso_code}
							<span class="caret"></span>
						</button>
						<ul class="dropdown-menu">
							{foreach from=$languages item=lang}
							<li><a href="javascript:hideOtherLanguage({$lang.id_lang});" tabindex="-1">{$lang.name}</a></li>
							{/foreach}
						</ul>
					</div>
				{/if}
			</div>
			{if $languages|count > 1}
				</div>
			{/if}
			<script>
			$(document).ready(function(){

				$('.an-image-deletebutton-{$language.id_lang}').click(function(e){
					if (confirm('Are you sure?') ) {
						var formGroupImage = $(this).closest('.form-group-image');
					
						$(formGroupImage).append('<input type="hidden" name="delete_{$input.name}[{$language.id_lang}]" value="{$language.id_lang}" /> ');

						$(formGroupImage).find('.form-group').fadeOut(function () {
							$(this).remove();
						});
                	}
				});

				$('#{$input.name}_{$language.id_lang}-selectbutton').click(function(e){
					$('#{$input.name}_{$language.id_lang}').trigger('click');
				});
				$('#{$input.name}_{$language.id_lang}').change(function(e){
					var val = $(this).val();
					var file = val.split(/[\\/]/);
					$('#{$input.name}_{$language.id_lang}-name').val(file[file.length-1]);
				});
			});
			</script>
		{/foreach}
		{if isset($input.desc) && !empty($input.desc)}
			<p class="help-block">
				{$input.desc}
			</p>
		{/if}

	{elseif $input.type == 'html'}
		{if isset($input.html_content)}
			{if $input.html_content == 'hr'}
			<hr />
			{else}
			{$input.html_content}
			{/if}
		{else}
			{$input.name|escape:'htmlall':'UTF-8'}
		{/if}
	{else}	
		{$smarty.block.parent}
    {/if}
{/block}