<?php
/**
 * 2022 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2022 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

require_once _PS_MODULE_DIR_ . 'an_homeslider/classes/anHomeSliders.php';

class AdminAnhomeSlidersController extends ModuleAdminController
{
    protected $_module = null;
    

    public function __construct()
    {
        $this->bootstrap = true;
        $this->context = Context::getContext();
        $this->table = 'an_homeslider_sliders';
        $this->identifier = 'id_slider';
        $this->className = 'anHomeSliders';
        $this->lang = true;

        $this->addRowAction('edit');
        $this->addRowAction('delete');
 
        $this->name = 'AdminAnhomeSlidersController';
        
        parent::__construct();

        $this->fields_list = [
            'id_slider' => [
                'title' => $this->l('ID'), 
                'width' => 25,
                'search'  => false,
            ],

            'title_slider' => [
                'title' => $this->l('Title'), 
                'search'  => false,
            ],   
            
            'hook' => [
                'title' => $this->l('Hook'), 
                'search'  => false,
            ],  
            
            'active' => [
                'title' => $this->l('Status'),
                'width' => 40,
                'active' => 'update',
                'align' => 'center',
                'type' => 'bool',
                'search'  => false,
                'orderby' => false
            ],

            'viewBut' => [
                'title' => $this->l('View'), 
                'search'  => false,
                'type' => 'image',
            ] 
            
        ];

        if (Shop::isFeatureActive() && Shop::getContext() != Shop::CONTEXT_ALL) {
            $this->_where .= ' AND a.' . $this->identifier . ' IN (
                SELECT sa.' . $this->identifier . '
                FROM `' . _DB_PREFIX_ . $this->table . '_shop` sa
                WHERE sa.id_shop IN (' . implode(', ', Shop::getContextListShopID()) . ')
            )';
        }
    }

    public function getList($id_lang, $order_by = null, $order_way = null, $start = 0, $limit = null, $id_lang_shop = false)
    {
        parent::getList($id_lang, $order_by, $order_way, $start, $limit, $id_lang_shop);

        foreach ($this->_list as &$list) {   

            $this->context->smarty->assign('widget', [
                'action' => 'View',
                'href' => $this->context->link->getAdminLink('AdminAnhomeSlides'). '&id_parent='. $list['id_slider'] ,
            ]);
			
			$list['viewBut'] = $this->module->display(_PS_MODULE_DIR_.'an_homeslider', 'views/templates/admin/list_action_view.tpl');

        } 
    }    
    
    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->addJquery();
        $this->js_files[] = _MODULE_DIR_ . 'an_homeslider/views/js/Sortable.min.js';
        $this->js_files[] = _MODULE_DIR_ . 'an_homeslider/views/js/sorting.js';
        $this->js_files[] = _MODULE_DIR_ . 'an_homeslider/views/js/back.js';
        $this->css_files[_MODULE_DIR_ . 'an_homeslider/views/css/back.css'] = 'all';
    }    
    
    public function renderList()
    {            
        return parent::renderList() . $this->module->topPromo();
    } 

    public function initToolBarTitle()
    {
        $this->toolbar_title[] = $this->l('Home Slider: Sliders');
    }

    

    public function initHeader()
    {
        parent::initHeader();

        $id_lang = $this->context->language->id;
        $link = $this->context->link;
        $tabs = &$this->context->smarty->tpl_vars['tabs']->value;

        foreach ($tabs as &$tab0) {
            if ($tab0['class_name'] == 'IMPROVE') {
                foreach ($tab0['sub_tabs'] as &$tab1) {
                    if ($tab1['class_name'] == 'AdminParentModulesSf') {
                        
                        foreach ($tab1['sub_tabs'] as &$tab2) {
                            if ($tab2['class_name'] == 'AdminAnhomeSliders') {
                                $sub_tabs = &$tab2['sub_tabs'];

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminAnhomeSliders'));
                                $tab['current'] = true;
                                $tab['href'] = $link->getAdminLink('AdminAnhomeSliders');
                                $tab['active'] = true;
                                $sub_tabs[] = $tab; 

                                break;
                            }
                        }
                        break;
                    }
                }
                break;
            }
        }
    }    
    
    public function initContent()
    {
        $this->context->smarty->assign('current_tab_level', 3);

        return parent::initContent();
    }    
    
    public function renderForm()
    {
        $this->initToolbar();
         if (!$this->loadObject(true)) {
            return;
        } 

        $this->fields_form = array(
            'tinymce' => false,
            'legend' => ['title' => $this->l('Home Slider: Slider')],
            'input' => [],
            'buttons' => [
                [
                    'type' => 'submit',
                    'title' => $this->l('Save'),
                    'icon' => 'process-icon-save',
                    'class' => 'pull-right',
                    'name' => 'submit'.$this->table
                ],
                [
                    'type' => 'submit',
                    'title' => $this->l('Save and stay'),
                    'icon' => 'process-icon-save',
                    'class' => 'pull-right',
                    'name' => 'submit'.$this->table.'AndStay'
                ],
            ],
        );

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'active',
            'label' => $this->l('Active'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];         

        $this->fields_form['input'][] = array(
            'col' => 6,
            'type' => 'select',
            'name' => 'hook',
            'label' => $this->module->l('Select hook'),
            'options' => array(
                'query' => $this->module->getHooksQuery(),
                'id' => 'name',
                'name' => 'name'
            ),  
        );

        $this->fields_form['input'][] = [
            'type' => 'text',
            'name' => 'title_slider',
            'label' => $this->l('Title'),    
            'lang' => true,
        ];    

        /**
         * 
         */

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'preloader',
            'label' => $this->l('Preloader'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];

        $this->fields_form['input'][] = [
            'type' => 'number',
            'label' => $this->l('Preloader height on 1920'),
            'name' => 'preloader_height_1920',
            'lang' => false,
            'col' => 2,
            'min' => 1,
            'max' => 50000,
        ];

        $this->fields_form['input'][] = [
            'type' => 'number',
            'label' => $this->l('Preloader height on 1600'),
            'name' => 'preloader_height_1600',
            'lang' => false,
            'col' => 2,
            'min' => 1,
            'max' => 50000,
        ];

        $this->fields_form['input'][] = [
            'type' => 'number',
            'label' => $this->l('Preloader height on 1366'),
            'name' => 'preloader_height_1366',
            'lang' => false,
            'col' => 2,
            'min' => 1,
            'max' => 50000,
        ];

        $this->fields_form['input'][] = [
            'type' => 'number',
            'label' => $this->l('Preloader height on 991'),
            'name' => 'preloader_height_991',
            'lang' => false,
            'col' => 2,
            'min' => 1,
            'max' => 50000,
        ];

        $this->fields_form['input'][] = [
            'type' => 'number',
            'label' => $this->l('Preloader height on 767'),
            'name' => 'preloader_height_767',
            'lang' => false,
            'col' => 2,
            'min' => 1,
            'max' => 50000,
        ];

        /**
         * 
         */

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'lazy_load',
            'label' => $this->l('LazyLoad'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];

        /**
         *  
         */

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'loop',
            'label' => $this->l('Loop'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'nav',
            'label' => $this->l('Nav'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'dots',
            'label' => $this->l('Dots'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'autoplay',
            'label' => $this->l('Autoplay'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];

        $this->fields_form['input'][] = [
            'type' => 'number',
            'label' => $this->l('smartSpeed'),
            'name' => 'smartspeed',
            'lang' => false,
            'col' => 2,
            'min' => 1,
            'max' => 50000,
        ];

        /**
         * 
         */

        $this->fields_form['input'][] = [
            'type' => 'number',
            'label' => $this->l('Autoplay Timeout'),
            'name' => 'autoplay_timeout',
            'lang' => false,
            'col' => 2,
            'min' => 1,
            'max' => 50000,
        ];

        /**
         * 
         */

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'responsive_image',
            'label' => $this->l('Responsive Image'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];
        
        /**
         * 
         */

        $this->fields_form['input'][] = [
            'type' => 'radio',
            'label' => $this->l('Show on:'),
            'name' => 'show_on',
            'default_value' => 0,
            'class' => 'an-hp-block-type',
            'values' => [
                [
                    'id' => 'desktop_mobile',
                    'value' => '0',
                    'label' => $this->l('Desktop & Mobile')
                ],

                [
                    'id' => 'desktop',
                    'value' => '1',
                    'label' => $this->l('Desktop'),
                ], 

                [
                    'id' => 'mobile',
                    'value' => '2',
                    'label' => $this->l('Mobile')
                ],                      
            ],
        ]; 

        $this->fields_form['input'][] = [
            'type' => 'radio',
            'label' => $this->l('Show Content on:'),
            'name' => 'show_content_on',
            'default_value' => 0,
            'class' => 'an-hp-block-type',
            'values' => [
                [
                    'id' => 'desktop_mobile',
                    'value' => '0',
                    'label' => $this->l('Desktop & Mobile')
                ],

                [
                    'id' => 'desktop',
                    'value' => '1',
                    'label' => $this->l('Desktop'),
                ], 

                [
                    'id' => 'mobile',
                    'value' => '2',
                    'label' => $this->l('Mobile')
                ],
                                 
            ],
        ];

        if (Shop::isFeatureActive()) {
            $this->fields_form['input'][] = [
                'required' => true,
                'type' => 'shop',
                'label' => $this->l('Shop association'),
                'name' => 'checkBoxShopAsso',
            ];
        }

        return parent::renderForm();
    }
  
    public function processSave()
    {
        if (_PS_MODE_DEMO_) {
            $this->errors[] = $this->module->textDemoMode;
            return false;
        }
  
        $object = parent::processSave();
        
        anHomeSliders::exportJsonSliders();

        if (isset($object->id) && $object->id) {
            
            $this->module->registerHook($object->hook);
            
            

            if (Tools::getIsset('submit'.$this->table.'AndStay')) {
                $this->redirect_after = $this->context->link->getAdminLink($this->controller_name).'&conf=4&updatean_homeslider_sliders&token='.$this->token.'&id_slider='.$object->id;
            }
        }    
    }

    public function processDelete()
    {    
        $object = parent::processDelete();
        anHomeSlides::deleteSlidesByIdSlider($object->id_slider);	
        anHomeSliders::exportJsonSliders();
        return $object;
    }   

    protected function updateAssoShop($id_object)
    {
        if (!Shop::isFeatureActive()) {
            return;
        }

        $assos_data = $this->getSelectedAssoShop($this->table, $id_object);

        $exclude_ids = $assos_data;

        foreach (Db::getInstance()->executeS('SELECT id_shop FROM ' . _DB_PREFIX_ . 'shop') as $row) {
            if (!$this->context->employee->hasAuthOnShop($row['id_shop'])) {
                $exclude_ids[] = $row['id_shop'];
            }
        }

        Db::getInstance()->delete($this->table . '_shop', '`' . $this->identifier . '` = ' . (int) $id_object . ($exclude_ids ? ' AND id_shop NOT IN (' . implode(', ', $exclude_ids) . ')' : ''));

        $insert = array();

        foreach ($assos_data as $id_shop) {
            $insert[] = array(
                $this->identifier => $id_object,
                'id_shop' => (int) $id_shop,
            );
        }

        return Db::getInstance()->insert($this->table . '_shop', $insert, false, true, Db::INSERT_IGNORE);
    }

    protected function getSelectedAssoShop($table)
    {
        if (!Shop::isFeatureActive()) {
            return array();
        }

        $shops = Shop::getShops(true, null, true);

        if (count($shops) == 1 && isset($shops[0])) {
            return array($shops[0], 'shop');
        }

        $assos = array();

        if (Tools::isSubmit('checkBoxShopAsso_' . $table)) {
            foreach (Tools::getValue('checkBoxShopAsso_' . $table) as $id_shop => $value) {
                $assos[] = (int) $id_shop;
            }
        } else if (Shop::getTotalShops(false) == 1) {
            // if we do not have the checkBox multishop, we can have an admin with only one shop and being in multishop
            $assos[] = (int) Shop::getContextShopID();
        }

        return $assos;
    }    
    
}
