<?php
/**
 * 2022 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2022 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

require_once _PS_MODULE_DIR_ . 'an_homeproducts/classes/anHomeProductsBlocks.php';

class an_homeproductsajaxModuleFrontController extends ModuleFrontController
{
    public function initContent()
    { 
        $this->assignGeneralPurposeVariables();
        
        $result = [];
        if (Tools::isSubmit('action')) {

            if (Tools::getValue('token') != Tools::getToken(false)){
                Tools::redirect('index.php?controller=404');
            }

            $actionName = Tools::getValue('action', '') . 'Action';
            if (method_exists($this, $actionName)) {
                $result = $this->$actionName();
            }
        }

        die(json_encode($result));
    }    
    
    public function getProductsAction()
    {
        $return = [];

        $config = [
            'view_type' => Configuration::get('an_hp_view_type'),
            'show_sort' => Configuration::get('an_hp_show_sort'),
            'slider' => Configuration::get('an_hp_slider'),

            'slider_nav' => Configuration::get('an_hp_slider_nav'),
            'slider_dots' => Configuration::get('an_hp_slider_dots'),
            'slider_loop' => Configuration::get('an_hp_slider_loop'),

            'show_load_more' => Configuration::get('an_show_load_more'),
            'title' => Configuration::get('an_hp_title', $this->context->language->id),
            'text' => Configuration::get('an_hp_text', $this->context->language->id),
        ];        

        $blockId = Tools::getValue('blockId');
        $type = Tools::getValue('type');

        $params = [
            'page' => (int) Tools::getValue('page'),
            'sort' => Tools::getValue('sort'),
            'idCategory' => (int) Tools::getValue('idCategory'),
        ];

        $blockObj = new anHomeProductsBlocks($blockId, $this->context->language->id);
        $blockObj->getData($params);
        $block = (array)$blockObj;

        $templateFile = 'ajax-products.tpl';
        if ($type == 'tab'){
            $templateFile = 'content.tpl'; 
            $this->context->smarty->assign('block', $block);
        }

        $this->context->smarty->assign('widget', [
            'banners' => anHomeProductsBanners::getBanners(),
            'config' => $config
        ]);
        $this->context->smarty->assign('products', $block['products']);


        $return['productsNextPage'] = $block['productsNextPage'];
        $return['products'] = $this->module->display($this->module->name, $templateFile);

        die(json_encode($return));
    }    

}