<?php
/**
 * 2021 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2021 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

class anHomeProductsBanners extends ObjectModel
{
    /**
     * @var int
     */
    public $id_banner;
    /**
     * @var int
     */
    public $id;

    public $special_id_banner;

    public $block;
    public $block_position = 0;
    public $col = 12;
    public $template;
    public $active = 1;
    public $position;
    
    public $title;
    public $text;
    public $link;
    public $image;


    /**
     * @var array
     */
    public static $definition = [
        'table' => 'an_homeproducts_banners',
        'primary' => 'id_banner',
        'multilang' => true,
        'fields' => [
            'special_id_banner' => ['type' =>self::TYPE_STRING ],
            'block' => ['type' =>self::TYPE_STRING ],
            'block_position' => ['type' =>self::TYPE_INT ],
            'col' => ['type' =>self::TYPE_INT ],
            'template' => ['type' =>self::TYPE_STRING ],
            'active' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'position' => ['type' =>self::TYPE_INT ],
            
            'title' => ['type' =>self::TYPE_STRING,'lang' => true ],
            'text' => ['type' =>self::TYPE_HTML,'lang' => true ],
            'link' => ['type' =>self::TYPE_STRING,'lang' => true ],
            'image' => ['type' =>self::TYPE_STRING,'lang' => true ],
        ],
    ];

    public const imgDir = _PS_MODULE_DIR_.'an_homeproducts/img/';
    public const imgUrl = __PS_BASE_URI__.'modules/an_homeproducts/img/';
    public const fileJsonBanners = _PS_MODULE_DIR_ . 'an_homeproducts/banners.json';
    public const tplsDir = _PS_MODULE_DIR_ . 'an_homeproducts/views/templates/front/banners/';
    public const tplsThemeDir = _PS_THEME_DIR_ . 'modules/an_homeproducts/banners/';
    public const tplPath = './banners/';


    /**
     * Formula constructor.
     *
     * @param null $id
     */
    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);

        $this->imgUrlFile = '';
        if (!is_array($this->image) && $this->image){
           $this->imgUrlFile = self::imgUrl . $this->image;
        }

        if ($this->template == ''){
            $this->template = 'default';
        }

        if (Tools::file_exists_no_cache(self::tplsThemeDir . $this->template . '.tpl')){
            $this->tplFilePath = self::tplsThemeDir . $this->template . '.tpl';
        } else if (Tools::file_exists_no_cache(self::tplsDir . $this->template . '.tpl')){
            $this->tplFilePath = self::tplPath . $this->template . '.tpl';
        }
    }

    public function add($auto_date = true, $null_values = false)
    {
        if (empty($this->special_id_banner)) {
            $this->special_id_banner = uniqid();
        }
    
        return parent::add($auto_date, $null_values);
    }    

    public static function getListTpl()
    {
        $list = [];

        $tplsTheme = glob(self::tplsThemeDir . '*.tpl');
        foreach ($tplsTheme as $tpl){
            $list[] = str_replace('.tpl', '', basename($tpl));
        }

        $tplsMod = glob(self::tplsDir . '*.tpl');
        foreach ($tplsMod as $tpl){
            $list[] = str_replace('.tpl', '', basename($tpl));
        }

        $list = array_unique($list);

        $return = [];
        foreach ($list as $item){
            $return[]['file'] = $item;
        }
    
        return $return;
    }
    

    public static function getBanners($forExport = false, $all = false)
    {
        $context = Context::getContext();
        
		$sql = '
		SELECT * FROM `' . _DB_PREFIX_ . 'an_homeproducts_banners` sw
		LEFT JOIN `' . _DB_PREFIX_ . 'an_homeproducts_banners_lang` sl 
			ON (sw.`id_banner` = sl.`id_banner`
            AND sl.`id_lang` = ' . (int) $context->language->id . ')
		';	
        if (!$all){
            $sql .= 'WHERE sw.`active`=1 ';
        }

		if (Shop::isFeatureActive()) {
			$sql .= ' AND sw.`id_banner` IN (
				SELECT sa.`id_banner`
				FROM `' . _DB_PREFIX_ . 'an_homeproducts_banners_shop` sa
				WHERE sa.id_shop IN (' . implode(', ', Shop::getContextListShopID()) . ')
			)';
		}	

        $sql .= ' ORDER BY sw.`position`';
		
		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

        if ($forExport){
            return $result;
        }

        $banners = [];
        foreach ($result as $id => $banner){
            $obj = new anHomeProductsBanners($banner['id_banner'], $context->language->id);
            $banners[$banner['block']][$banner['block_position']][$banner['id_banner']] = (array) $obj;
        }

        return $banners;
    }


    public function delete()
    {        
        foreach ($this->image as $imgName){
            @unlink(self::imgDir . $imgName);
        }

        return parent::delete();
    }

    public static function findTemplatesBanners()
    {

    }



    
    public static function exportJsonBanners()
	{
		$banners = self::getBanners(true, true);	
        
        foreach ($banners as $key => $banner){
            $obj = new anHomeProductsBanners($banner['id_banner']);
            $banners[$key]['imagesLang'] = $obj->image;

        }

		@file_put_contents(self::fileJsonBanners, json_encode($banners));
	}	

	public static function importJsonBanners()
	{
		$data = json_decode(Tools::file_get_contents(self::fileJsonBanners), true);
		$context = Context::getContext();
        $languages = Language::getLanguages();

		if ($data){
			
			foreach ($data as $item){
            
				$bannerObj = new anHomeProductsBanners();
				$bannerObj->special_id_banner = $item['special_id_banner'];
				$bannerObj->block = $item['block'];
				$bannerObj->block_position = $item['block_position'];
				$bannerObj->col = $item['col'];
                $bannerObj->template = $item['template'];
				$bannerObj->active = $item['active'];
				$bannerObj->position = $item['position'];
                						
				foreach ($languages as $language) {
					$bannerObj->title[$language['id_lang']] = $item['title'];
					$bannerObj->text[$language['id_lang']] = $item['text'];
					$bannerObj->link[$language['id_lang']] = $item['link'];

                    if (!isset($bannerObj->image[$language['id_lang']]) && 
                        isset($item['imagesLang'][$language['id_lang']]) && 
                        $item['imagesLang'][$language['id_lang']] != $item['image']){
                            $bannerObj->image[$language['id_lang']] = $item['imagesLang'][$language['id_lang']];
                    } else {
                        $nameImage = $item['image'];
                        if (is_array($bannerObj->image) && in_array($item['image'], $bannerObj->image)){
                            $nameImage = $language['id_lang'] . '_' . $item['image'];
                            copy(self::imgDir . $item['image'], self::imgDir . $nameImage);
                        }
                        $bannerObj->image[$language['id_lang']] = $nameImage;
                    }
				}	
                
				$bannerObj->save();
			}
		}
	}    
}