<?php
/**
 * 2022 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2022 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

require_once _PS_MODULE_DIR_ . 'an_homeproducts/classes/anHomeProductsBlocks.php';
require_once _PS_MODULE_DIR_ . 'an_homeproducts/classes/anHomeProductsBanners.php';

class an_homeproducts extends Module implements WidgetInterface
{

	const PREFIX = 'an_hp_';
	
    protected $_tabs = [
 
        [
            'class_name' => 'AdminAnhomeproductsBlocks',
            'parent' => 'AdminParentModulesSf',
            'name' => 'Products to display',
			'active' => 0
        ],		
 
        [
            'class_name' => 'AdminAnhomeproductsSettings',
            'parent' => 'AdminParentModulesSf',
            'name' => 'Settings',
			'active' => 0
        ],	
        
        [
            'class_name' => 'AdminAnhomeproductsBanners',
            'parent' => 'AdminParentModulesSf',
            'name' => 'Banners',
			'active' => 0
        ],	        
    ];	

    public function __construct()
    {
        $this->name = 'an_homeproducts';
        $this->tab = 'others';
        $this->version = '1.0.6';
        $this->author = 'Anvanto';
        $this->need_instance = 0;

        $this->bootstrap = true;
        $this->module_key = '';

        parent::__construct();

        $this->displayName = $this->l('Home Products');
        $this->description = $this->l('New arrivals, Best sellers, Specials, Category, Categories (multiple), Featured products and Banners');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall the module?');

        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);

        $this->templateFile['blocks'] = '/views/templates/front/widget-blocks.tpl'; 
        $this->templateFile['tabs'] = '/views/templates/front/widget-tabs.tpl'; 
    }

    /**
     * @return bool
     */
    public function install()
    {
		$sql = include _PS_MODULE_DIR_ . $this->name . '/sql/install.php';
		foreach ($sql as $_sql) {
			Db::getInstance()->Execute($_sql);
		} 
			
		$languages = Language::getLanguages();
		foreach ($this->_tabs as $tab) {
			$_tab = new Tab();
			$_tab->active = $tab['active'];
			$_tab->class_name = $tab['class_name'];
			$_tab->id_parent = Tab::getIdFromClassName($tab['parent']);
			if (empty($_tab->id_parent)) {
				$_tab->id_parent = 0;
			}

			$_tab->module = $this->name;
			foreach ($languages as $language) {
				$_tab->name[$language['id_lang']] = $this->l($tab['name']);
			}

			$_tab->add();
		}

        anHomeProductsBlocks::importJsonBlocks();
        anHomeProductsBanners::importJsonBanners();

        $this->_clearCache('*');
		
        return parent::install()
            && $this->registerHook('displayHeader')
            && $this->registerHook('displayHome')
            && $this->registerHook('actionProductAdd')
            && $this->registerHook('actionProductUpdate')
            && $this->registerHook('actionProductDelete')
            && $this->registerHook('actionObjectSpecificPriceCoreDeleteAfter')
            && $this->registerHook('actionObjectSpecificPriceCoreAddAfter')
            && $this->registerHook('actionObjectSpecificPriceCoreUpdateAfter')
            && $this->registerHook('actionCategoryUpdate')
            && $this->registerHook('actionAdminGroupsControllerSaveAfter');
    }

    /**
     * @return bool
     */
    public function uninstall()
    {
 		$sql = include _PS_MODULE_DIR_ . $this->name .  '/sql/uninstall.php';
		foreach ($sql as $_sql) {
			Db::getInstance()->Execute($_sql);
		} 	
		
		foreach ($this->_tabs as $tab) {
			$_tab_id = Tab::getIdFromClassName($tab['class_name']);
			$_tab = new Tab($_tab_id);
			$_tab->delete();
		}		
		
		$this->_clearCache('*');

        return parent::uninstall();
    }
	
    public function _clearCache($template, $cache_id = null, $compile_id = null)
    {
        parent::_clearCache('module:' . $this->name . $this->templateFile['blocks']);
        parent::_clearCache('module:' . $this->name . $this->templateFile['tabs']);
    }

    /**
     * @param $hookName
     * @param array $params
     * @return mixed|void
     */
    public function renderWidget($hookName, array $params)
    {
        $viewType = Configuration::get('an_hp_view_type');
        
        if (!$this->isCached($this->templateFile[$viewType], $this->getCacheId('an_homeproducts')) || !Configuration::get(self::PREFIX . 'use_cache')) {

            $title = Configuration::get(self::PREFIX . 'title', $this->context->language->id);
            $title = str_replace('[span]', '<span>', $title);
            $title = str_replace('[/span]', '</span>', $title);

            $config = [
                'view_type' => Configuration::get('an_hp_view_type'),
                'show_sort' => Configuration::get('an_hp_show_sort'),
                'slider' => Configuration::get('an_hp_slider'),

                'slider_nav' => Configuration::get('an_hp_slider_nav'),
                'slider_dots' => Configuration::get('an_hp_slider_dots'),
                'slider_loop' => Configuration::get('an_hp_slider_loop'),

                'show_load_more' => Configuration::get(self::PREFIX . 'show_load_more'),
                'title' => $title,
                'text' => Configuration::get(self::PREFIX . 'text', $this->context->language->id),
            ];
            
            $blocks = anHomeProductsBlocks::getBlocks();
            $banners = anHomeProductsBanners::getBanners();
            
            $this->smarty->assign('widget', [
                'blocks' => $blocks,
                'banners' => $banners,
                'config' => $config,
                'urlProducts' => $this->context->link->getModuleLink('an_homeproducts', 'ajax', ['token' => Tools::getToken(false)], true),
            ]);
        }

        if (Configuration::get(self::PREFIX . 'use_cache')){ 
            return $this->display(__FILE__, $this->templateFile[$viewType], $this->getCacheId('an_homeproducts'));
        } else {
            return $this->display(__FILE__, $this->templateFile[$viewType]);
        }   
    }

    /**
     * @param $hookName
     * @param array $params
     * @return array
     */
    public function getWidgetVariables($hookName, array $params)
    {			
		$widgets = [];
		return $widgets;
    }
	
	public function getContent()
	{
		Tools::redirectAdmin($this->context->link->getAdminLink('AdminAnhomeproductsBlocks'));
	}

    public function hookActionProductAdd($params)
    {
        $this->_clearCache('*');
    }
 
    public function hookActionProductUpdate($params)
    {
        $this->_clearCache('*');
    }

    public function hookActionProductDelete($params)
    {
        $this->_clearCache('*');
    }

    public function hookActionObjectSpecificPriceCoreDeleteAfter($params)
    {
        $this->_clearCache('*');
    }

    public function hookActionObjectSpecificPriceCoreAddAfter($params)
    {
        $this->_clearCache('*');
    }

    public function hookActionObjectSpecificPriceCoreUpdateAfter($params)
    {
        $this->_clearCache('*');
    }

    public function hookActionOrderStatusPostUpdate($params)
    {
        $this->_clearCache('*');
    }

    public function hookActionCategoryUpdate($params)
    {
        $this->_clearCache('*');
    }

    public function hookActionAdminGroupsControllerSaveAfter($params)
    {
        $this->_clearCache('*');
    }


    public function hookHeader()
    {
        $this->hookDisplayHeader();
    }

    public function hookDisplayHeader()
    {
	
        $this->context->controller->addJquery();
		
        if (Configuration::get(self::PREFIX . 'slider')){
            
            $this->context->controller->registerStylesheet(
                $this->name . "_css_carusel",
                $this->getCSJSFilePath('owl.carousel.min.css'),
                ['server' => 'local', 'priority' => 150]
            );
    
            $this->context->controller->registerJavascript(
                $this->name . "_js_carusel",
                $this->getCSJSFilePath('owl.carousel.min.js'),
                array('server' => 'local', 'priority' => 150)
            ); 
    
            $this->context->controller->registerJavascript(
                $this->name . "_js_init_slider",
                'modules/' . $this->name . '/views/js/init.slider.js',
                array('server' => 'local', 'priority' => 150)
            );
        }

		$this->context->controller->registerStylesheet(
			$this->name . "_css",
			'modules/' . $this->name . '/views/css/front.css',
			['server' => 'local', 'priority' => 150]
		);
		
        $this->context->controller->registerJavascript(
			$this->name . "_js",
			'modules/' . $this->name . '/views/js/front.js',
			['server' => 'local', 'priority' => 150]
		);

    }

    public function getCSJSFilePath($file = '')
    {
        if ($file == ''){
            return false;
        }

        $ex = explode('.', $file);
        $fileType = end($ex);
        
        if (Tools::file_exists_no_cache(_PS_THEME_DIR_.'/assets/lib/' . $file)){
            $path = 'themes/'._THEME_NAME_.'/assets/lib/' . $file;   
        } else if (Tools::file_exists_no_cache('modules/anthemeblocks/views/' . $fileType . '/' . $file)){
            $path = 'modules/anthemeblocks/views/' . $fileType . '/' . $file; 
        } else {    
            $path = 'modules/' . $this->name . '/views/' . $fileType . '/' . $file;      
        } 

        return $path;
    }
    
	public function topPromo()
	{		
		$this->context->smarty->assign('theme', $this->getThemeInfo());
        return $this->display(__FILE__, 'views/templates/admin/top.tpl');
	}
	
	public function getThemeInfo()
	{
		$theme = [];
		$themeFileJson = _PS_THEME_DIR_.'/config/theme.json';
		if (Tools::file_exists_no_cache($themeFileJson)) {
			$theme = (array)json_decode(Tools::file_get_contents($themeFileJson), 1);			
		}

		if (!isset($theme['url_contact_us']) || $theme['url_contact_us'] == ''){
			
			$urlContactUs = 'https://addons.prestashop.com/contact-form.php';

			if (isset($theme['addons_id']) && $theme['addons_id'] != ''){
				$urlContactUs .= '?id_product=' .$theme['addons_id'];
			} elseif (isset($this->url_contact_us) && $this->url_contact_us != ''){
				$urlContactUs = $this->url_contact_us;
			} elseif (isset($this->addons_product_id) && $this->addons_product_id != ''){
				$urlContactUs .= '?id_product=' .$this->addons_product_id;
			}
			
			$theme['url_contact_us'] = $urlContactUs;
		}
		
		if (!isset($theme['url_rate']) || $theme['url_rate'] == ''){
			
			$urlRate = 'https://addons.prestashop.com/ratings.php';

			if (isset($theme['addons_id']) && $theme['addons_id'] != ''){
				$urlRate .= '?id_product=' .$theme['addons_id'];
			} elseif (isset($this->url_rate) && $this->url_rate != ''){
				$urlRate = $this->url_rate;
			} elseif (isset($this->addons_product_id) && $this->addons_product_id != ''){
				$urlRate .= '?id_product=' .$this->addons_product_id;
			}
			
			$theme['url_rate'] = $urlRate;
		}		
		
		return $theme;
	}
}
