<?php
/**
 * 2022 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2022 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
*/

require_once _PS_MODULE_DIR_ . 'an_advantages/classes/AnAdvantages.php';

class AdminAnadvantagesBlocktextController extends ModuleAdminController
{
    protected $_module = null;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->display = 'view';
 
		$this->name = 'AdminAnadvantagesBlocktextController';
		
        parent::__construct();
    }
    
    public function initToolBarTitle()
    {
        $this->toolbar_title[] = $this->module->l('Block text');
    }

    public function initHeader()
    {
        parent::initHeader();

        $id_lang = $this->context->language->id;
        $link = $this->context->link;
        $tabs = &$this->context->smarty->tpl_vars['tabs']->value;

        foreach ($tabs as &$tab0) {
            if ($tab0['class_name'] == 'IMPROVE') {
                foreach ($tab0['sub_tabs'] as &$tab1) {
                    if ($tab1['class_name'] == 'AdminParentModulesSf') {
						
                        foreach ($tab1['sub_tabs'] as &$tab2) {
                            if ($tab2['class_name'] == 'AdminAnadvantagesBlocktext') {
                                $sub_tabs = &$tab2['sub_tabs'];

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminAnAdvantages'));
                                $tab['current'] = false;
                                $tab['href'] = $link->getAdminLink('AdminAnAdvantages');
                                $tab['active'] = true;
                                $sub_tabs[] = $tab;  

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminAnadvantagesBlocktext'));
                                $tab['current'] = true;
                                $tab['href'] = $link->getAdminLink('AdminAnadvantagesBlocktext');
                                $tab['active'] = true;
                                $sub_tabs[] = $tab;

                                break;
                            }
                        }
                        break;
                    }
                }
                break;
            }
        }
    }	
	
    public function initContent()
    {
        $this->context->smarty->assign('current_tab_level', 3);

        return parent::initContent();
    }    
    /**
     * Create the structure of your form.
     */
    protected function getSettingsForm()
    {
        $form['form']['legend'] = [
            'title' => $this->l('Block text'),
        ];

        $form['form']['submit'] = [
            'name' => 'save',
            'title' => $this->l('Save'),
        ];

        $form['form']['input'][] = [
			'type' => 'switch',
			'name' => an_advantages::PREFIX . 'show_block',
			'label' => $this->l('Show block'),
			'values' => [
				[
					'id' => 'active_on',
					'value' => 1,
					'label' => $this->l('Enabled')
				],
				[
					'id' => 'active_off',
					'value' => 0,
					'label' => $this->l('Disabled')
                ]
			],
		];

        $form['form']['input'][] = [
            'type' => 'text',
            'label' => $this->l('Title'),
            'name' => an_advantages::PREFIX . 'title',
            'lang' => true,
        ];

        $form['form']['input'][] = [
			'type' => 'textarea',
			'class' => 'autoload_rte',
			'name' => an_advantages::PREFIX . 'text',
			'label' => $this->l('Text'),	
            'lang' => true,
            'html' => true,
        ];

        return $form;
    }

    public function renderView()
    {
        $languages = $this->context->controller->getLanguages();
  
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->name_controller = $this->name;
        $helper->submit_action = $this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminAnadvantagesBlocktext', false);
        $helper->token = Tools::getAdminTokenLite('AdminAnadvantagesBlocktext');
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->tpl_vars = [
            'uri' => $this->module->getPathUri(),
            'languages' => $languages,
            'id_language' => $this->context->language->id
        ];

        $form = $this->getSettingsForm();

        foreach ($form['form']['input'] as $input){
            if (isset($input['lang']) && $input['lang']){
                $value = [];
                foreach ($languages  as $language){
                    $value[$language['id_lang']] = Configuration::get($input['name'], $language['id_lang']);
                }
                $helper->tpl_vars['fields_value'][$input['name']] = $value;
            } else {
                $helper->tpl_vars['fields_value'][$input['name']] = Configuration::get($input['name']);
            }
        }
        	
        return $this->module->topPromo() . $helper->generateForm([$form]);		
	}

    public function postProcess()
    {    
        $form = $this->getSettingsForm();
        
        if (Tools::isSubmit($form['form']['submit']['name'])) {

            $languages = Language::getLanguages(false);
            
            foreach ($form['form']['input'] as $input){

                $html = false;
                if (isset($input['html']) && $input['html']){
                    $html = true;
                }

                if (isset($input['lang']) && $input['lang']){
                    $value = [];
                    foreach ($languages  as $language){
                        $value[$language['id_lang']] = Tools::getValue($input['name'].'_' . $language['id_lang']);
                    }
        
                    Configuration::updateValue($input['name'], $value, $html);
                } else {
                    Configuration::updateValue($input['name'], Tools::getValue($input['name']), $html);
                }
            }

            $currentIndex = $this->context->link->getAdminLink('AdminAnadvantagesBlocktext', false);
            $token = Tools::getAdminTokenLite('AdminAnadvantagesBlocktext'); 
            
            $this->module->exportJsonSettings();
            
            Tools::redirectAdmin($currentIndex . '&token=' . $token . '&conf=4');
        }
		return true;
    }
}