<?php
/**
 * 2021 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2021 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

class AnAdvantages extends ObjectModel
{
    public $id_advantage;
 
    public $id;
    
    public $active = 1;
    public $position;

    public $image;
    
    public $title;
    public $link;
    public $text;

    public static $definition = [
        'table' => 'an_advantages',
        'primary' => 'id_advantage',
        'multilang' => true,
        'fields' => [
            
            'active' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'position' => ['type' =>self::TYPE_INT ],
            
            'image' => ['type' =>self::TYPE_STRING],

            'title' => ['type' =>self::TYPE_STRING,'lang' => true ],
            'link' => ['type' =>self::TYPE_STRING,'lang' => true ],
            'text' => ['type' =>self::TYPE_HTML,'lang' => true ],
            
        ],
    ];

    public const imgDir = _PS_MODULE_DIR_.'an_advantages/img/';
    public const imgUrl = __PS_BASE_URI__.'modules/an_advantages/img/';

    public const fileJsonAdvantages = _PS_MODULE_DIR_ . 'an_advantages/advantages.json';
    public const fileJsonSettings = _PS_MODULE_DIR_ . 'an_advantages/settings.json';

    public function __construct($id = null)
    {
        parent::__construct($id);
    }

    public static function getAdvantages($pathImg = true)
    {
        
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'an_advantages` aa
        LEFT JOIN `' . _DB_PREFIX_ . 'an_advantages_lang` aal
        ON (aal.`id_advantage` = aa.`id_advantage` 
        AND aal.`id_lang` = '.(int) Context::getContext()->language->id.' )
        WHERE  aa.`active` = 1 '; 
        
        if (Shop::isFeatureActive()) {
			$sql .= ' AND aa.`id_advantage` IN (
				SELECT aas.`id_advantage`
				FROM `' . _DB_PREFIX_ . 'an_advantages_shop` aas
				WHERE aas.id_shop IN (' . implode(', ', Shop::getContextListShopID()) . ')
			)';
		}

        $sql .= ' ORDER BY aa.`position`';

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);

        if($pathImg){  
            foreach($result as $id => $val){
                if ($val['image'] !=''){
                    $result[$id]['image'] = self::imgUrl . $val['image'];
                }
               
            }
        }    

        return $result;         
    }   

    public function delete()
    {        
        @unlink(self::imgDir . $this->image);
        return parent::delete();
    }  

    public static function exportJsonAdvantages()
	{
		$advantages = self::getAdvantages(false);	
        
        foreach ($advantages as $key => $advantage){
            $obj = new AnAdvantages($advantage['id_advantage']);
        }

		@file_put_contents(self::fileJsonAdvantages, json_encode($advantages));
	}	

	public static function importJsonAdvantages()
	{
		$data = json_decode(Tools::file_get_contents(self::fileJsonAdvantages), true);
		$context = Context::getContext();

		if ($data){
			
			foreach ($data as $item){
            
				$advantagesObj = new AnAdvantages();
				$advantagesObj->id_advantage = $item['id_advantage'];
				$advantagesObj->active = $item['active'];
				$advantagesObj->position = $item['position'];

                $advantagesObj->image = $item['image'];
				
				$languages = Language::getLanguages();
				foreach ($languages as $language) {
					$advantagesObj->title[$language['id_lang']] = $item['title'];
					$advantagesObj->text[$language['id_lang']] = $item['text'];
					$advantagesObj->link[$language['id_lang']] = $item['link'];
				}				

				$advantagesObj->save();
			}
		}
	}    
}