<?php
/**
 * 2021 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2021 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */


class AdminAnAboutController extends ModuleAdminController
{
    protected $_module = null;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->display = 'view';
 
		$this->name = 'AdminAnAboutController';
		
        parent::__construct();
    }

    /**
     * Create the structure of your form.
     */
    public function viewImage($thumb)
    {
        if (!$thumb || $thumb == ''){
            return false;
        }

        $this->context->smarty->assign([
            'image' => an_about_us::imgUrl . $thumb,
        ]);

        return $this->module->display(_PS_MODULE_DIR_.'an_about_us', 'views/templates/admin/an_about_us/helpers/form/image_class.tpl');   
    }

    protected function getSettingsForm()
    {
        $form['form']['legend'] = [
            'title' => $this->l('Block text'),
        ];

        $form['form']['submit'] = [
            'name' => 'save',
            'title' => $this->l('Save'),
        ];

        $form['form']['input'][] = [
            'type' => 'file',
            'label' => $this->l('Image'),
            'name' => 'about_image',
            'lang' => false,
            'image' => $this->viewImage(Configuration::get(an_about_us::PREFIX . 'about_image')),
            'delete_url' =>  $this->context->link->getAdminLink('AdminAnAbout') . '&deleteBackgroundImage=',
        ];

        $form['form']['input'][] = [
			'type' => 'text',
            'label' => $this->l('Link'), 
            'name' => an_about_us::PREFIX . 'link_about_us',
            'lang' => true,
		];

        $form['form']['input'][] = [
            'type' => 'text',
            'label' => $this->l('Title'),
            'name' => an_about_us::PREFIX . 'title',
            'lang' => true,
        ];

        $form['form']['input'][] = [
			'type' => 'textarea',
			'class' => 'autoload_rte',
			'name' => an_about_us::PREFIX . 'text',
			'label' => $this->l('Text'),	
            'lang' => true,
            'html' => true,
        ];

        return $form;
    }

    public function renderView()
    {
        $languages = $this->context->controller->getLanguages();
  
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->name_controller = $this->name;
        $helper->submit_action = $this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminAnAbout', false);
        $helper->token = Tools::getAdminTokenLite('AdminAnAbout');
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->tpl_vars = [
            'uri' => $this->module->getPathUri(),
            'languages' => $languages,
            'id_language' => $this->context->language->id
        ];

        $form = $this->getSettingsForm();

        foreach ($form['form']['input'] as $input){
            if (isset($input['lang']) && $input['lang']){
                $value = [];
                foreach ($languages  as $language){
                    $value[$language['id_lang']] = Configuration::get($input['name'], $language['id_lang']);
                }
                $helper->tpl_vars['fields_value'][$input['name']] = $value;
            } else {
                $helper->tpl_vars['fields_value'][$input['name']] = Configuration::get($input['name']);
            }
        }
        	
        return $this->module->topPromo() . $helper->generateForm([$form]);		
	}

    public function postProcess()
    {    
        if (isset($_FILES['about_image']) && isset($_FILES['about_image']['tmp_name']) && !empty($_FILES['about_image']['tmp_name'])) {
            if ($error = $this->validateUpload($_FILES['about_image'])) {
                $this->errors[] = $error;                 
            }
        }

        if (!empty($this->errors)) {
            $this->display = 'edit';
            return false;
        } 

        $this->deleteImg();
        $form = $this->getSettingsForm();
        
        if (Tools::isSubmit($form['form']['submit']['name'])) {

            $languages = Language::getLanguages(false);
            
            foreach ($form['form']['input'] as $input){

                $html = false;
                if (isset($input['html']) && $input['html']){
                    $html = true;
                }
                if ($input['type'] == 'file'){
                    $this->saveImageAbout();
                } elseif (isset($input['lang']) && $input['lang']){
                    $value = [];
                    foreach ($languages  as $language){
                        $value[$language['id_lang']] = Tools::getValue($input['name'].'_' . $language['id_lang']);
                    }
        
                    Configuration::updateValue($input['name'], $value, $html);
                } else {
                    Configuration::updateValue($input['name'], Tools::getValue($input['name']), $html);  
                }
            }  
            $currentIndex = $this->context->link->getAdminLink('AdminAnAbout', false);
            $token = Tools::getAdminTokenLite('AdminAnAbout');		
          
            $this->module->exportJsonSettings();

            Tools::redirectAdmin($currentIndex.'&token='.$token.'&conf=4'); 
        }
		return  true;
    }

    public function saveImageAbout(){
		
        if (isset($_FILES['about_image']) && isset($_FILES['about_image']['tmp_name'])
            && !empty($_FILES['about_image']['tmp_name'])) {

            $ext = substr($_FILES['about_image']['name'], strrpos($_FILES['about_image']['name'], '.') + 1);
            $fileName = md5(uniqid()) . '.' . $ext;

            if (!move_uploaded_file($_FILES['about_image']['tmp_name'], an_about_us::imgDir . $fileName)) {
                return $this->displayError($this->trans('An error occurred while attempting to upload the file.', [], 'Admin.Notifications.Error'));
            }
                    
            if (Configuration::get(an_about_us::PREFIX.'about_image') !=''){
                @unlink(an_about_us::imgDir . Tools::getValue('about_image'));
            }
            Configuration::updateValue(an_about_us::PREFIX.'about_image', $fileName);      
                       
        }
    }

    public function validateUpload($file)
    {
        $maxFileSize = 4000000;
        $types = ['gif', 'jpg', 'jpeg', 'jpe', 'png', 'svg'];

        if ((int) $maxFileSize > 0 && $file['size'] > (int) $maxFileSize) {
            return Context::getContext()->getTranslator()->trans('Image is too large (%1$d kB). Maximum allowed: %2$d kB', [$file['size'] / 1024, $maxFileSize / 1024], 'Admin.Notifications.Error');
        }

        if (!ImageManager::isCorrectImageFileExt($file['name'], $types) || preg_match('/\%00/', $file['name'])) {
            return Context::getContext()->getTranslator()->trans('Image format not recognized, allowed formats are: .gif, .jpg, .png, .svg', [], 'Admin.Notifications.Error');
        }  

        if ($file['error']) {
            return Context::getContext()->getTranslator()->trans('Error while uploading image; please change your server\'s settings. (Error code: %s)', [$file['error']], 'Admin.Notifications.Error');
        }   
        
        return false;
    }

    public function deleteImg()
    {
        if (Tools::getIsset('deleteBackgroundImage')) {
            if (Configuration::get(an_about_us::PREFIX.'about_image') !=''){

                @unlink(an_about_us::imgDir . Configuration::get(an_about_us::PREFIX.'about_image'));
                Configuration::updateValue(an_about_us::PREFIX.'about_image', '');

            }   
        }
    }
}

?>