<?php
/**
* 2022 Anvanto
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
*
*  @author    Anvanto <anvantoco@gmail.com>
*  @copyright 2022 Anvanto
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

class an_about_us extends Module implements WidgetInterface
{ 
    const PREFIX = 'an_a_us_';
    const imgDir = _PS_MODULE_DIR_.'an_about_us/img/';
    const imgUrl = __PS_BASE_URI__.'modules/an_about_us/img/';
    const fileJsonSettings = _PS_MODULE_DIR_ . 'an_about_us/settings.json';

    protected $_tabs = array(

        array(
            'class_name' => 'AdminAnAbout',
            'parent' => 'AdminParentModulesSf',
            'name' => 'About us',
            'active' => 0
        ),
    ); 

    public function __construct()
    {
        $this->name = 'an_about_us';
        $this->tab = 'others';
        $this->version = '1.0.2';
        $this->author = 'Anvanto';
        $this->need_instance = 0;

        $this->bootstrap = true;
        $this->module_key = '';

        parent::__construct();

        $this->displayName = $this->l('Simple About Us Block');
        $this->description = $this->l('Simple About Us Block');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall the module?');

        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);

        $this->modulePath = _MODULE_DIR_ . 'an_about_us/'; 
    }


    public function install()
    {
        $languages = Language::getLanguages();
        foreach ($this->_tabs as $tab) {
            $_tab = new Tab();
            $_tab->active = $tab['active'];
            $_tab->class_name = $tab['class_name'];
            $_tab->id_parent = Tab::getIdFromClassName($tab['parent']);
            if (empty($_tab->id_parent)) {
                $_tab->id_parent = 0;
            }

            $_tab->module = $this->name;
            foreach ($languages as $language) {
                $_tab->name[$language['id_lang']] = $this->l($tab['name']);
            }

            $_tab->add();
        }    
        
        $this->importJsonSettings();

        return parent::install()
            && $this->registerHook('displayHome')
            && $this->registerHook('displayHeader');
    }

    
    public function uninstall()
    {
        foreach ($this->_tabs as $tab) {
            $_tab_id = Tab::getIdFromClassName($tab['class_name']);
            $_tab = new Tab($_tab_id);
            $_tab->delete();
        } 

        return parent::uninstall();
    }

    public function exportJsonSettings()
	{ 
		$settings = [
            'about_image' => Configuration::get(an_about_us::PREFIX . 'about_image'),
            'title' => Configuration::get(an_about_us::PREFIX . 'title', Context::getContext()->language->id),
            'text' => Configuration::get(an_about_us::PREFIX . 'text', Context::getContext()->language->id),
            'link_about_us' => Configuration::get(an_about_us::PREFIX . 'link_about_us', Context::getContext()->language->id),
        ];

		@file_put_contents(an_about_us::fileJsonSettings, json_encode($settings));
	}	

    public function importJsonSettings()
    {
        $data = json_decode(Tools::file_get_contents(an_about_us::fileJsonSettings), true);

        $context = Context::getContext();

        if ($data){
            $languages = Language::getLanguages(false);
            foreach ($data as $id => $value){
                if($id == 'title' || $id == 'text' || $id == 'link_about_us'){

                    $valueTitleLeft = [];
                    foreach ($languages as $lang) {
                        $valueTitle[$lang['id_lang']] = $value;
                    }
                    Configuration::updateValue(an_about_us::PREFIX . $id, $valueTitle);
                } else {
                    Configuration::updateValue(an_about_us::PREFIX . $id, $value);
                }
            }
        }
    }
	
  
    public function renderWidget($hookName, array $params)
    {
        $aboutImage = '';
        if (Configuration::get(an_about_us::PREFIX . 'about_image') != ''){
            $aboutImage = an_about_us::imgUrl . Configuration::get(an_about_us::PREFIX . 'about_image');
        }

        $widget = [
            'about_image' => $aboutImage,
            'title' => Configuration::get(an_about_us::PREFIX . 'title', Context::getContext()->language->id),
            'text' => Configuration::get(an_about_us::PREFIX . 'text', Context::getContext()->language->id),
            'link' => Configuration::get(an_about_us::PREFIX . 'link_about_us', Context::getContext()->language->id),
        ];
        
        $this->smarty->assign('widget', $widget);
        return $this->fetch('module:' . $this->name . '/views/templates/front/widget.tpl');
    }

    

    public function getWidgetVariables($hookName, array $params)
    {			
        
    }

    public function hookHeader()
    {
        $this->hookDisplayHeader();
    }

    public function hookDisplayHeader()
    {
        $this->context->controller->registerStylesheet(
            $this->name . "_css",
            'modules/' . $this->name . '/views/css/front.css',
            ['server' => 'local', 'priority' => 150]
        );
    }

    public function getContent()
	{	
        Tools::redirectAdmin($this->context->link->getAdminLink('AdminAnAbout'));    
	}

    public function topPromo()
	{		
		$this->context->smarty->assign('theme', $this->getThemeInfo());
        return $this->display(__FILE__, 'views/templates/admin/top.tpl');
	}
	
	public function getThemeInfo()
	{
		$theme = [];
		$themeFileJson = _PS_THEME_DIR_.'/config/theme.json';
		if (Tools::file_exists_no_cache($themeFileJson)) {
			$theme = (array)json_decode(Tools::file_get_contents($themeFileJson), 1);			
		}

		if (!isset($theme['url_contact_us']) || $theme['url_contact_us'] == ''){
			
			$urlContactUs = 'https://addons.prestashop.com/contact-form.php';

			if (isset($theme['addons_id']) && $theme['addons_id'] != ''){
				$urlContactUs .= '?id_product=' .$theme['addons_id'];
			} elseif (isset($this->url_contact_us) && $this->url_contact_us != ''){
				$urlContactUs = $this->url_contact_us;
			} elseif (isset($this->addons_product_id) && $this->addons_product_id != ''){
				$urlContactUs .= '?id_product=' .$this->addons_product_id;
			}
			
			$theme['url_contact_us'] = $urlContactUs;
		}
		
		if (!isset($theme['url_rate']) || $theme['url_rate'] == ''){
			
			$urlRate = 'https://addons.prestashop.com/ratings.php';

			if (isset($theme['addons_id']) && $theme['addons_id'] != ''){
				$urlRate .= '?id_product=' .$theme['addons_id'];
			} elseif (isset($this->url_rate) && $this->url_rate != ''){
				$urlRate = $this->url_rate;
			} elseif (isset($this->addons_product_id) && $this->addons_product_id != ''){
				$urlRate .= '?id_product=' .$this->addons_product_id;
			}
			
			$theme['url_rate'] = $urlRate;
		}		
		
		return $theme;
	}
}
