{*
* 2018 Anvanto
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author Anvanto (anvantoco@gmail.com)
*  @copyright  2018 anvanto.com

*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<article class="blog-item">
	<div class="blog-image-container">
		 {if $blog.preview_url && $config->get('listing_show_image',1)}
             <div class="blog-image">
                 <a href="{$blog.link|escape:'html':'UTF-8'}" title="{$blog.title|escape:'html':'UTF-8'}">
                     <img src="{$blog.preview_url|escape:'html':'UTF-8'}" title="{$blog.title|escape:'html':'UTF-8'}" alt="" class="img-fluid" />
                 </a>
             </div>
         {elseif $blog.thumb_url && $config->get('listing_show_image',1)}
             <div class="blog-image">
                 <img src="{$blog.thumb_url|escape:'html':'UTF-8'}" title="{$blog.title|escape:'html':'UTF-8'}" alt="" class="img-fluid" />
             </div>
         {/if}
         <div class="blog-meta">
             {if $config->get('listing_show_hit','1')}
                 <span class="blog-hit">
                     <i class="material-icons">visibility</i> <span> {$blog.hits|intval} {l s='Views' d='Shop.Theme.Global'}</span>

                 </span>
             {/if}

             {if $config->get('listing_show_created','1')}
                 <span class="blog-created">
                    <svg
                     xmlns="http://www.w3.org/2000/svg"
                     xmlns:xlink="http://www.w3.org/1999/xlink"
                     width="16px" height="16px">
                    <path fill-rule="evenodd"  fill="rgb(0, 0, 0)"
                     d="M3.906,12.625 C3.561,12.625 3.281,12.345 3.281,12.000 C3.281,11.655 3.561,11.375 3.906,11.375 C4.252,11.375 4.531,11.655 4.531,12.000 C4.531,12.345 4.252,12.625 3.906,12.625 ZM3.906,7.187 C3.561,7.187 3.281,6.908 3.281,6.563 C3.281,6.217 3.561,5.938 3.906,5.938 C4.252,5.938 4.531,6.217 4.531,6.563 C4.531,6.908 4.252,7.187 3.906,7.187 ZM3.906,9.906 C3.561,9.906 3.281,9.627 3.281,9.281 C3.281,8.936 3.561,8.656 3.906,8.656 C4.252,8.656 4.531,8.936 4.531,9.281 C4.531,9.627 4.252,9.906 3.906,9.906 ZM6.625,12.625 C6.280,12.625 6.000,12.345 6.000,12.000 C6.000,11.655 6.280,11.375 6.625,11.375 C6.970,11.375 7.250,11.655 7.250,12.000 C7.250,12.345 6.970,12.625 6.625,12.625 ZM6.625,7.187 C6.280,7.187 6.000,6.908 6.000,6.563 C6.000,6.217 6.280,5.938 6.625,5.938 C6.970,5.938 7.250,6.217 7.250,6.563 C7.250,6.908 6.970,7.187 6.625,7.187 ZM6.625,9.906 C6.280,9.906 6.000,9.627 6.000,9.281 C6.000,8.936 6.280,8.656 6.625,8.656 C6.970,8.656 7.250,8.936 7.250,9.281 C7.250,9.627 6.970,9.906 6.625,9.906 ZM15.375,7.937 C15.030,7.937 14.750,7.658 14.750,7.313 L14.750,3.750 C14.750,3.061 14.189,2.500 13.500,2.500 L12.688,2.500 L12.688,3.125 C12.688,3.470 12.408,3.750 12.063,3.750 C11.717,3.750 11.437,3.470 11.437,3.125 L11.437,2.500 L8.594,2.500 L8.594,3.125 C8.594,3.470 8.314,3.750 7.969,3.750 C7.624,3.750 7.344,3.470 7.344,3.125 L7.344,2.500 L4.531,2.500 L4.531,3.125 C4.531,3.470 4.252,3.750 3.906,3.750 C3.561,3.750 3.281,3.470 3.281,3.125 L3.281,2.500 L2.500,2.500 C1.811,2.500 1.250,3.061 1.250,3.750 L1.250,13.500 C1.250,14.189 1.811,14.750 2.500,14.750 L7.281,14.750 C7.626,14.750 7.906,15.030 7.906,15.375 C7.906,15.720 7.626,16.000 7.281,16.000 L2.500,16.000 C1.122,16.000 0.000,14.879 0.000,13.500 L0.000,3.750 C0.000,2.371 1.122,1.250 2.500,1.250 L3.281,1.250 L3.281,0.625 C3.281,0.280 3.561,-0.000 3.906,-0.000 C4.252,-0.000 4.531,0.280 4.531,0.625 L4.531,1.250 L7.344,1.250 L7.344,0.625 C7.344,0.280 7.624,-0.000 7.969,-0.000 C8.314,-0.000 8.594,0.280 8.594,0.625 L8.594,1.250 L11.437,1.250 L11.437,0.625 C11.437,0.280 11.717,-0.000 12.063,-0.000 C12.408,-0.000 12.688,0.280 12.688,0.625 L12.688,1.250 L13.500,1.250 C14.878,1.250 16.000,2.371 16.000,3.750 L16.000,7.313 C16.000,7.658 15.720,7.937 15.375,7.937 ZM8.719,6.563 C8.719,6.217 8.999,5.938 9.344,5.938 C9.689,5.938 9.969,6.217 9.969,6.563 C9.969,6.908 9.689,7.187 9.344,7.187 C8.999,7.187 8.719,6.908 8.719,6.563 ZM11.437,6.563 C11.437,6.217 11.717,5.938 12.063,5.938 C12.408,5.938 12.688,6.217 12.688,6.563 C12.688,6.908 12.408,7.187 12.063,7.187 C11.717,7.187 11.437,6.908 11.437,6.563 ZM12.219,8.438 C14.304,8.438 16.000,10.134 16.000,12.219 C16.000,14.304 14.304,16.000 12.219,16.000 C10.134,16.000 8.438,14.304 8.438,12.219 C8.438,10.134 10.134,8.438 12.219,8.438 ZM12.219,14.750 C13.614,14.750 14.750,13.615 14.750,12.219 C14.750,10.823 13.614,9.687 12.219,9.687 C10.823,9.687 9.688,10.823 9.688,12.219 C9.688,13.615 10.823,14.750 12.219,14.750 ZM12.219,10.312 C12.564,10.312 12.844,10.592 12.844,10.937 L12.844,11.594 L13.125,11.594 C13.470,11.594 13.750,11.874 13.750,12.219 C13.750,12.564 13.470,12.844 13.125,12.844 L12.219,12.844 C11.874,12.844 11.594,12.564 11.594,12.219 L11.594,10.937 C11.594,10.592 11.874,10.312 12.219,10.312 Z"/>
                    </svg>
                     <time class="date" datetime="{strtotime($blog.date_add)|date_format:"%Y"|escape:'html':'UTF-8'}">
                         {assign var='blog_day' value=strtotime($blog.date_add)|date_format:"%e"}{l s=$blog_day d='Shop.Theme.Global'}/{assign var='blog_month' value=strtotime($blog.date_add)|date_format:"%m"}{l s=$blog_month d='Shop.Theme.Global'}/{assign var='blog_year' value=strtotime($blog.date_add)|date_format:"%Y"}{l s=$blog_year d='Shop.Theme.Global'}
                     </time>
                 </span>
             {/if}

             {if isset($blog.comment_count)&&$config->get('listing_show_counter','1')}
                 <span class="blog-ctncomment">
                    <svg
                     xmlns="http://www.w3.org/2000/svg"
                     xmlns:xlink="http://www.w3.org/1999/xlink"
                     width="17px" height="15px">
                    <path fill-rule="evenodd"  fill="rgb(0, 0, 0)"
                     d="M14.663,11.717 L7.248,11.717 L2.329,15.000 L2.329,11.717 C1.044,11.713 -0.000,10.709 -0.000,9.475 L-0.000,2.241 C-0.000,1.005 1.048,-0.000 2.337,-0.000 L14.663,-0.000 C15.952,-0.000 17.000,1.005 17.000,2.241 L17.000,9.475 C17.000,10.712 15.952,11.717 14.663,11.717 ZM16.004,2.241 C16.004,1.532 15.402,0.955 14.663,0.955 L2.337,0.955 C1.598,0.955 0.996,1.532 0.996,2.241 L0.996,9.475 C0.996,10.185 1.598,10.762 2.337,10.762 L3.325,10.762 L3.325,13.171 L6.936,10.762 L14.663,10.762 C15.402,10.762 16.004,10.185 16.004,9.475 L16.004,2.241 ZM4.550,7.452 L12.450,7.452 L12.450,8.407 L4.550,8.407 L4.550,7.452 ZM4.550,5.414 L12.450,5.414 L12.450,6.369 L4.550,6.369 L4.550,5.414 ZM4.550,3.376 L12.450,3.376 L12.450,4.331 L4.550,4.331 L4.550,3.376 Z"/>
                    </svg> <span> {$blog.comment_count|intval} {l s='comments' d='Shop.Theme.Global'}</span>

                 </span>
             {/if}

             {if $config->get('listing_show_author','1')&&!empty($blog.author)}
                 <span class="blog-author">
                     <i class="material-icons">person</i> <span>{l s='Posted By' d='Shop.Theme.Global'}:</span>
                     <a href="{$blog.author_link|escape:'html':'UTF-8'}" title="{$blog.author|escape:'html':'UTF-8'}">{$blog.author|escape:'html':'UTF-8'}</a>
                 </span>
             {/if}

             {if $config->get('listing_show_category','1')}
                 <span class="blog-cat">
                     <i class="material-icons">list</i> <span>{l s='In' d='Shop.Theme.Global'}:</span>
                     <a href="{$blog.category_link|escape:'html':'UTF-8'}" title="{$blog.category_title|escape:'html':'UTF-8'}">{$blog.category_title|escape:'html':'UTF-8'}</a>
                 </span>
             {/if}
         </div>
         {if $config->get('listing_show_title','1')}
             <h4 class="title">
                 <a href="{$blog.link|escape:'html':'UTF-8'}" title="{$blog.title|escape:'html':'UTF-8'}">{$blog.title|escape:'html':'UTF-8'}</a>
             </h4>
         {/if}

	</div>
	 <div class="blog-info">
        {if $config->get('listing_show_description','1')}
            <div class="blog-shortinfo">
                {$blog.description|strip_tags:'UTF-8'|truncate:90:'...' nofilter}{* HTML form , no escape necessary *}
            </div>
        {/if}
        {if $config->get('listing_show_readmore',1)}
            <p>
                <a href="{$blog.link|escape:'html':'UTF-8'}" title="{$blog.title|escape:'html':'UTF-8'}" class="more btn btn-primary">{l s='Leer más' d='Shop.Theme.Global'}</a>
            </p>
        {/if}
    </div>
	
	<div class="hidden-xl-down hidden-xl-up datetime-translate">
		{l s='Sunday' d='Shop.Theme.Global'}
		{l s='Monday' d='Shop.Theme.Global'}
		{l s='Tuesday' d='Shop.Theme.Global'}
		{l s='Wednesday' d='Shop.Theme.Global'}
		{l s='Thursday' d='Shop.Theme.Global'}
		{l s='Friday' d='Shop.Theme.Global'}
		{l s='Saturday' d='Shop.Theme.Global'}
		
		{l s='January' d='Shop.Theme.Global'}
		{l s='February' d='Shop.Theme.Global'}
		{l s='March' d='Shop.Theme.Global'}
		{l s='April' d='Shop.Theme.Global'}
		{l s='May' d='Shop.Theme.Global'}
		{l s='June' d='Shop.Theme.Global'}
		{l s='July' d='Shop.Theme.Global'}
		{l s='August' d='Shop.Theme.Global'}
		{l s='September' d='Shop.Theme.Global'}
		{l s='October' d='Shop.Theme.Global'}
		{l s='November' d='Shop.Theme.Global'}
		{l s='December' d='Shop.Theme.Global'}
					
	</div>
</article>
