{**
* 2021 Anvanto
*
* NOTICE OF LICENSE
*
* This file is not open source! Each license that you purchased is only available for 1 wesite only.
* If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
* You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
*
*  @author Anvanto <anvantoco@gmail.com>
*  @copyright  2021 Anvanto
*  @license    Valid for 1 website (or project) for each purchase of license
*  International Registered Trademark & Property of Anvanto
*}

{if $productData}
<div class="an_table">
	{foreach from=$productData key=k item=v}
		<div class="an_table-item">
			{if $config.display_image}
				<div class="an-table-column an-table-image">
					{if isset($v['image']['cover'])}
					<img src="{$v['image']['cover']|escape:'htmlall':'UTF-8'}">
					{else}
					-
					{/if}
				</div>
			{/if}
			{if $config.display_reference}
				<div class="an-table-column an-table-column-padding">
					{if strlen($v['comb'][0]['reference']) > 0}
						{l s='Reference' mod='anproductextratabs'}: <br />
						{$v['comb'][0]['reference']|escape:'htmlall':'UTF-8'}
					{else}
						-
					{/if}
				</div>
			{/if}
			
			{if $config['display_attributes']}
				{if $config['combine_attributes']}
					<div class="an-table-column an-table-column-padding">
						{foreach from=$productData[$k]['comb'] key=k3 item=v3}
							<b>{$v3['group_name']|escape:'htmlall':'UTF-8'}</b>: {$v3['attribute_name']|escape:'htmlall':'UTF-8'};
						{/foreach}
					</div>
				{else}
					{foreach from=$productData[$k]['comb'] key=k3 item=v3}
						<div>{$v3['attribute_name']|escape:'htmlall':'UTF-8'}</div>
					{/foreach}
				{/if}
			{/if}
			
			{if $config.display_price}
				<div class="an-table-column anproductextratabs-container-prices">
					<span class="anproductextratabs-price">{$v.prices.price|escape:'htmlall':'UTF-8'}</span>
					{if isset($v.prices.regular_price)}
					<span class="anproductextratabs-regular-price" style="text-decoration: line-through;">{$v.prices.regular_price|escape:'htmlall':'UTF-8'}</span>
					{/if}						

					{if isset($v.prices.has_discount)}
					{if $v.prices.discount_type == 'percentage'}
					<span class="anproductextratabs-sale" style="background: #e53d60; color: #ffffff;">{$v.prices.discount_percentage|escape:'htmlall':'UTF-8'}
					</span>
					{/if}
					{if $v.prices.discount_type == 'amount'}
					<span class="anproductextratabs-sale" style="background: #e53d60; color: #ffffff;">{l s='Save' mod='an_productattributes'} {$v.prices.discount_amount|escape:'htmlall':'UTF-8'}
					{/if}				
					</span>
					{/if}
					
					{if !$v.availableForOrder}
					<span class="anproductextratabs-sold-out" style="background: #ffc427; color: #ffffff;">{l s='Sold out' mod='an_productattributes'}</span>
					{/if}

				</div>
			{/if}
			
				
				{if $config.display_add_to_cart}
				<div class="an-table-column an-table-column-add">
					<form method="post" action="{$cart|escape:'htmlall':'UTF-8'}" class="">

					<input name="token" value="{$token|escape:'htmlall':'UTF-8'}" type="hidden">
					<input name="id_product" value="{$product_id|escape:'htmlall':'UTF-8'}" type="hidden">
					<input name="id_product_attribute" type="hidden" data-role="id_product_attribute" value="{$k|intval}">						

					<div class="anproductextratabs-qty-add clearfix">
						{if $config.display_field_quantity}
						<div class="anproductextratabs-qty">
						    <div class="quantity-button quantity-down">–</div>
							<input name="qty" type="text" value="{$productData[$k]['comb'][0]['minimal_quantity']|escape:'htmlall':'UTF-8'}" min="{$productData[$k]['comb'][0]['minimal_quantity']|escape:'htmlall':'UTF-8'}" data-role="qty" class="an_input_q">
                            <div class="quantity-button quantity-up">+</div>
						</div>
						{else}
						<input name="qty" type="hidden" value="{$productData[$k]['comb'][0]['minimal_quantity']|escape:'htmlall':'UTF-8'}" min="{$productData[$k]['comb'][0]['minimal_quantity']|escape:'htmlall':'UTF-8'}" data-role="qty">
						{/if}
	
						<div class="anproductextratabs-add">
							<button class="btn btn-primary " data-button-action="add-to-cart" type="submit" {if $v.availableForOrder !='1'} disabled="disabled"{/if} data-status="{$v.availableForOrder|escape:'htmlall':'UTF-8'}">
							<i class="material-icons shopping-cart"></i>
							{l s='Add to cart' d='Shop.Theme.Actions'}
							</button>
						</div>
					</div>
					</form>
				</div>
				{/if}
			
		</div>
	{/foreach}
</div>
{/if}