/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

(function () {
    'use strict';

    // Initialize all user events when DOM ready
    window.addEventListener('load', initConfigForm, false);

    //document.addEventListener('submit', prepareForm, false);

    function initConfigForm() {
        initCaveatModal();
        initSiteSpeedSampleRateInput();
        initTextareaListInputs();
        initDimensionsInputs();
        initGoalInputs();
    }

    function initCaveatModal() {
        let moduleCaveatDoneNode;
        const moduleCaveatNode = document.querySelector('#gtm_caveat');

        if (moduleCaveatNode instanceof HTMLInputElement && moduleCaveatNode.value) {
            // enable caveat modal
            $('#module-caveat-modal').modal();

            // get caveat done button and bind click event
            moduleCaveatDoneNode = document.querySelector('#module-caveat-done');
            moduleCaveatDoneNode.addEventListener('click', eventCaveatModal, false);
        }
    }

    // clean input modal value
    function eventCaveatModal() {
        const moduleCaveatNode = document.querySelector('#gtm_caveat');
        moduleCaveatNode.value = '';
    }

    function initSiteSpeedSampleRateInput() {
        const inputNode = document.querySelector('#gua_site_speed_sample_rate');
        inputNode.addEventListener('input', eventSiteSpeedSampleRate);
        inputNode.value = validateSiteSpeedSampleRate(inputNode.value);
    }

    function eventSiteSpeedSampleRate(event) {
        const inputNode = event.target;
        const inputValue = Number(inputNode.value);
        inputNode.value = validateSiteSpeedSampleRate(inputValue);
    }

    function validateSiteSpeedSampleRate(value) {
        const min = 1;
        const max = 100;

        if (!isNaN(value)) {
            if (value > max) {
                return max;
            } else if (value < min) {
                return min;
            }
        } else {
            return min;
        }
        return value;
    }

    function initTextareaListInputs() {
        const areaListNodes = getTextareaNodes();

        if (areaListNodes.length) {
            areaListNodes.forEach((areaListNode) => {
                areaListNode.value = areaListNode.value.replace(/,/g, '\n');
            });
        }
    }

    function getTextareaNodes() {
        return document.querySelectorAll('.js-textarea-list');
    }

    function initDimensionsInputs() {
        const dimensionNodes = document.querySelectorAll('.js-dimensions');
        dimensionNodes.forEach((dimensionNode) => {
            dimensionNode.addEventListener('change', updateDimensions, false);
        });
        updateDimensions();
    }

    function updateDimensions() {
        const dimensionNodes = document.querySelectorAll('.js-dimensions');
        const optionsSelectedIds = [];
        dimensionNodes.forEach((node) => optionsSelectedIds.push(node.selectedIndex));
        dimensionNodes.forEach((dimensionNode, dimensionKey) => {
            const optionKeySelected = optionsSelectedIds[dimensionKey];
            Array.from(dimensionNode.options).forEach((option, optionKey) => {
                option.disabled = optionKey !== optionKeySelected && optionsSelectedIds.includes(optionKey);
            });
        });
    }

    function initGoalInputs() {
        const inputNodes = document.querySelectorAll('.js-event-value');

        inputNodes.forEach((inputNode) => {
            inputNode.addEventListener('input', eventGoalValue, false);
            inputNode.value = validateGoalValue(inputNode.value);
        });
    }

    function eventGoalValue(event) {
        const inputNode = event.target;
        const inputValue = Number(inputNode.value);
        inputNode.value = validateGoalValue(inputValue);
    }

    function validateGoalValue(value) {
        const min = 0;
        if (isNaN(value) || value < min) {
            return min;
        }
        return value;
    }
})();
