/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

(function () {
    'use strict';

    // Initialize all user events when DOM ready
    document.addEventListener('DOMContentLoaded', initCommonForm, false);

    function initCommonForm() {
        let formTabs;
        let inputsWithSelectInput;
        let inputsWithSelectMenu;

        formTabs = document.querySelector('#js-form-tabs');
        if (formTabs) {
            formTabs.addEventListener('click', toggleTabs, false);
        }

        inputsWithSelectInput = document.querySelectorAll('.js-inputwithselect-input');
        if (inputsWithSelectInput) {
            inputsWithSelectInput.forEach(function (inputWithSelectNode) {
                if (inputWithSelectNode.min || inputWithSelectNode.max) {
                    inputWithSelectNode.addEventListener('change', inputWithSelectInput, false);
                }
            });
        }

        inputsWithSelectMenu = document.querySelectorAll('.js-inputwithselect-menu');
        if (inputsWithSelectMenu) {
            inputsWithSelectMenu.forEach(function (inputWithSelectNode) {
                inputWithSelectNode.addEventListener('click', inputWithSelectMenu, false);
            });
        }
    }

    // toggle form tabs
    function toggleTabs(event) {
        const target = event.target.closest('.js-tab-item');
        let targetClassList;
        let tabsList;
        let tabsContent;

        if (event.button === 0 && target) {
            targetClassList = target.classList;
            if (targetClassList.contains('reachable') && !targetClassList.contains('active')) {
                tabsList = document.querySelectorAll('.js-tab-item');
                tabsContent = document.querySelectorAll('.js-tab-content');

                // handle tab column
                tabsList.forEach(function (tab) {
                    if (tab.id === target.id) {
                        tab.classList.add('active');
                    } else {
                        tab.classList.remove('active');
                    }
                });

                // handle form values
                tabsContent.forEach(function (content) {
                    if (content.id !== 'js-tab-content-' + target.id) {
                        content.classList.add('hidden');
                    } else {
                        content.classList.remove('hidden');
                    }
                });
            }
        }
    }

    // handle inputs with select options
    function inputWithSelectMenu(event) {
        const target = event.target.closest('.js-inputwithselect-option');
        let mainSelector = '.input-group_model-btn';
        let mainNode;
        let inputNode;
        let labelNode;

        if (event.button === 0 && target) {
            event.preventDefault();
            mainNode = target.closest(mainSelector);
            inputNode = mainNode.querySelector('input');
            inputNode.value = target.dataset.value;
            labelNode = mainNode.querySelector('.js-inputwithselect-label');
            labelNode.innerText = target.innerText.trim();
        }
    }

    // handle input limits
    function inputWithSelectInput(event) {
        const winnerInputNode = event.target;

        if (winnerInputNode.max) {
            if (Number(winnerInputNode.value) > Number(winnerInputNode.max)) {
                winnerInputNode.value = winnerInputNode.max;
            }
        }

        if (winnerInputNode.min) {
            if (Number(winnerInputNode.value) < Number(winnerInputNode.min)) {
                winnerInputNode.value = winnerInputNode.min;
            }
        }
    }
})();
