<?php

namespace ReactionCode\RCPGTagManager\TheIconic\Tracking\GoogleAnalytics\Parameters;

use ReactionCode\RCPGTagManager\TheIconic\Tracking\GoogleAnalytics\Tests\SingleTestParameter;
use ReactionCode\RCPGTagManager\TheIconic\Tracking\GoogleAnalytics\Tests\SingleTestParameterIndexed;
use ReactionCode\RCPGTagManager\TheIconic\Tracking\GoogleAnalytics\Tests\InvalidSingleTestParameter;

class SingleParameterTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var SingleParameter
     */
    private $stubSingleParameter;

    /**
     * @var SingleParameter
     */
    private $stubSingleParameterIndexed;

    public function setUp()
    {
        $this->stubSingleParameter = new SingleTestParameter();
        $this->stubSingleParameterIndexed = new SingleTestParameterIndexed(2);
    }

    /**
     * @expectedException \ReactionCode\RCPGTagManager\TheIconic\Tracking\GoogleAnalytics\Exception\InvalidNameException
     */
    public function testInvalidSingleParameter()
    {
        (new InvalidSingleTestParameter);
    }

    /**
     * @expectedException \ReactionCode\RCPGTagManager\TheIconic\Tracking\GoogleAnalytics\Exception\InvalidIndexException
     */
    public function testInvalidSingleParameterIndexed()
    {
        (new SingleTestParameterIndexed());
    }

    public function testGetName()
    {
        $this->assertEquals('test', $this->stubSingleParameter->getName());
    }

    public function testGetNameIndexed()
    {
        $this->assertEquals('testi2', $this->stubSingleParameterIndexed->getName());
    }

    public function testValue()
    {
        $this->stubSingleParameter->setValue(10);

        $this->assertEquals(10, $this->stubSingleParameter->getValue());
    }
}
