<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

function upgrade_module_3_1_8()
{
    enableCaveat();
    deleteOldParams();
    upgradeRetailParams();
    return true;
}

function enableCaveat()
{
    $caveat_name = 'RCPGTAGMANAGER_GTM_CAVEAT';
    Configuration::deleteByName($caveat_name);
    Configuration::updateGlobalValue($caveat_name, '1');
}


function deleteOldParams()
{
    $old_config_params = [
        'RC_PGTAGMANAGER_CAVEAT',
        'RC_PGTAGMANAGER_NO_IT',
        'RC_PGTAGMANAGER_DNT',
        'RC_PGTAGMANAGER_ID',
        'RC_PGTAGMANAGER_GA_ID',
        'RC_PGTAGMANAGER_GA_PR',
        'RC_PGTAGMANAGER_GA_SSSR',
        'RC_PGTAGMANAGER_GA_AI',
        'RC_PGTAGMANAGER_GA_UI',
        'RC_PGTAGMANAGER_GA_LA',
        'RC_PGTAGMANAGER_GA_CDT',
        'RC_PGTAGMANAGER_GA_REL',
        'RC_PGTAGMANAGER_GA_RM',
        'RC_PGTAGMANAGER_GA_D1',
        'RC_PGTAGMANAGER_GA_D2',
        'RC_PGTAGMANAGER_GA_D3',
        'RC_PGTAGMANAGER_GA_D4',
        'RC_PGTAGMANAGER_GA_MC_PF',
        'RC_PGTAGMANAGER_GA_MC_SF',
        'RC_PGTAGMANAGER_GA_MC_VT',
        'RC_PGTAGMANAGER_BD',
        'RC_PGTAGMANAGER_GA_D5',
        'RC_PGTAGMANAGER_GA_D6',
        'RC_PGTAGMANAGER_GA_D7',
        'RC_PGTAGMANAGER_GA_D8',
        'RC_PGTAGMANAGER_BD_PF',
        'RC_PGTAGMANAGER_BD_VT',
        'RC_PGTAGMANAGER_AW_ID',
        'RC_PGTAGMANAGER_AW_CL',
        'RC_PGTAGMANAGER_OPT_ID',
        'RC_PGTAGMANAGER_OPT_HCN',
        'RC_PGTAGMANAGER_OPT_HTO',
        'RC_PGTAGMANAGER_BING_ID',
        'RC_PGTAGMANAGER_FB_ID',
        'RC_PGTAGMANAGER_FB_CAT_PF',
        'RC_PGTAGMANAGER_FB_CAT_SF',
        'RC_PGTAGMANAGER_FB_CAT_VT',
        'RC_PGTAGMANAGER_TW_ID',
        'RC_PGTAGMANAGER_GOAL_SU',
        'RC_PGTAGMANAGER_EVENT_SU',
        'RC_PGTAGMANAGER_GOAL_SA',
        'RC_PGTAGMANAGER_EVENT_SA',
        'RC_PGTAGMANAGER_GOAL_CO',
        'RC_PGTAGMANAGER_EVENT_CO',
        'RC_PGTAGMANAGER_IOS',
        'RC_PGTAGMANAGER_ROS',
    ];

    foreach ($old_config_params as $param_name) {
        Configuration::deleteByName($param_name);
    }
}

function upgradeRetailParams()
{
    $config_params = [
        [
            'new' => 'RCPGTAGMANAGER_GFEEDS_IS_REMARKETING_RETAIL',
            'old' => 'RCPGTAGMANAGER_GUA_IS_REMARKETING_RETAIL'
        ],
        [
            'new' => 'RCPGTAGMANAGER_GFEEDS_IS_REMARKETING_CUSTOM',
            'old' => 'RCPGTAGMANAGER_GUA_IS_REMARKETING_CUSTOM'
        ]
    ];
    foreach ($config_params as $config_param) {
        $multi_shop_values = Configuration::getMultiShopValues($config_param['old']);

        if (isGlobalConfiguration($multi_shop_values)) {
            $key = array_keys($multi_shop_values)[0];
            Configuration::updateGlobalValue($config_param['new'], $multi_shop_values[$key]);
        } else {
            foreach ($multi_shop_values as $id_shop => $value) {
                Configuration::updateValue($config_param['new'], $value, false, null, $id_shop);
            }
        }
        Configuration::deleteByName($config_param['old']);
    }
}

function isGlobalConfiguration(array $multi_shop_values): bool
{
    return count(array_unique($multi_shop_values)) === 1;
}
