<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\UserTrackingData;

use ReactionCode\RCPGTagManager\UserTrackingData\Components\UserTrackingDataComponentInterface;

class UserTrackingDataHandler
{
    /**
     * @var UserTrackingDataComponentInterface[]
     */
    private $tracking_data_components;

    public function __construct()
    {
        $this->setTrackingDataComponents();
    }

    private function setTrackingDataComponents()
    {
        $tracking_data_factory = new UserTrackingDataFactory();
        $this->tracking_data_components[] = $tracking_data_factory->createUserTrackingDataGA();
    }

    /**
     * @return array
     */
    public function getUserTrackingData(): array
    {
        $user_tracking_data = [];
        foreach ($this->tracking_data_components as $tracking_data_component) {
            $data = $tracking_data_component->getUserTrackingData();
            $platform_key = array_keys($data)[0];
            $user_tracking_data[$platform_key] = $data[$platform_key];
        }
        return $user_tracking_data;
    }
}
