<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\UserTrackingData\Components\GA;

use ReactionCode\RCPGTagManager\UserTrackingData\Components\AbstractUserTrackingDataComponent;

class UserTrackingDataGA extends AbstractUserTrackingDataComponent
{
    /**
     * @return string[][]
     */
    public function getUserTrackingData(): array
    {
        return [
            'ga' => [
                'cid' => $this->getClientID(),
                'gclid' => $this->getGAdsClick()
            ]
        ];
    }

    /**
     * @return string
     */
    private function getClientID(): string
    {
        return $this->getCookieClientID() ?? $this->getQueryClientID();
    }

    /**
     * @return string
     */
    private function getCookieClientID(): string
    {
        $cookie_value = explode('.', $this->getCookieValue('_ga'));
        return implode('.', array_slice($cookie_value, 2));
    }

    /**
     * @return string
     */
    private function getQueryClientID(): string
    {
        return !empty($this->queries['_gl']) ? $this->queries['_gl'] : '';
    }

    /**
     * @return string
     */
    private function getGAdsClick(): string
    {
        return $this->getCookieGAdsClick() ?? $this->getQueryGAdsClick();
    }

    /**
     * @return string
     */
    private function getCookieGAdsClick(): string
    {
        $cookie_value = explode('.', $this->getCookieValue('_gcl_aw'));
        return array_pop($cookie_value);
    }

    /**
     * @return string
     */
    private function getQueryGAdsClick(): string
    {
        return !empty($this->queries['gclid']) ? $this->queries['gclid'] : '';
    }
}
