<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\UserTrackingData\Components;

abstract class AbstractUserTrackingDataComponent implements UserTrackingDataComponentInterface
{
    /**
     * @var array
     */
    protected $queries = [];

    public function __construct()
    {
        $this->setQueryParams();
    }

    private function setQueryParams()
    {
        parse_str($_SERVER['QUERY_STRING'], $query_array);
        if (!empty($query_array)) {
            $this->queries = $query_array;
        }
    }

    /**
     * @param string $name
     * @return string
     */
    protected function getCookieValue(string $name): string
    {
        return isset($_COOKIE[$name]) ? $_COOKIE[$name] : '';
    }
}
