<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\TrackingAPI\Components\GUA;

use ReactionCode\RCPGTagManager\DataModel\Product\ProductModel;

class GUAAPIProductModel
{
    /**
     * @var ProductModel
     */
    private $source_model;

    /**
     * @var array
     */
    private $model;

    public function __construct(ProductModel $source_model)
    {
        $this->source_model = $source_model;
    }

    public function setBasic()
    {
        $this->model['sku'] = $this->source_model->getIdIndex();
        $this->model['price'] = $this->source_model->getPrice();
        $this->model['quantity'] = $this->source_model->getQuantity();
    }

    public function setDetail()
    {
        $this->model['name'] = $this->source_model->getName();
        $this->model['brand'] = $this->source_model->getManufacturerName();
        $this->model['category'] = $this->getCategory();
        $this->model['variant'] = $this->getVariant();
    }

    /**
     * @return string
     */
    private function getCategory(): string
    {
        $max_category_depth = 5;
        $category_separator = '/';
        $categories = $this->source_model->getCategoryModel()->getPath();

        return implode($category_separator, array_slice($categories, 0, $max_category_depth));
    }

    /**
     * @return string
     */
    private function getVariant(): string
    {
        $variant_detail_separator = ' : ';
        $variant_separator = ', ';
        $variants = $this->source_model->getAttributes();

        foreach ($variants as $index => $variant_details) {
            $variants[$index] = implode($variant_detail_separator, $variant_details);
        }

        return implode($variant_separator, $variants);
    }

    /**
     * @return array
     */
    public function getModel(): array
    {
        return $this->model;
    }
}
