<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\TrackingAPI\Components\GUA;

use RCPGTagManagerUserTrackingData;
use ReactionCode\RCPGTagManager\DataModel\Connections\ConnectionsModel;
use ReactionCode\RCPGTagManager\DataModel\Order\OrderModel;
use ReactionCode\RCPGTagManager\DataModel\Product\ProductModel;
use ReactionCode\RCPGTagManager\TrackingAPI\Components\AbstractAPIComponent;

class GUAAPI extends AbstractAPIComponent
{
    /**
     * @var GUAAPIFacade
     */
    private $api_client;

    /**
     * @inheritDoc
     */
    protected function isValidConfiguration(array $configuration): bool
    {
        return !empty($configuration['gua']) &&
            !empty($configuration['gua']['tracking_id'])
        ;
    }

    protected function setAPIClient()
    {
        $this->api_client = new GUAAPIFacade($this->configuration);
    }

    /**
     * @inheritDoc
     */
    public function setUserTrackingData(RCPGTagManagerUserTrackingData $user_tracking_data)
    {
        $this->api_client->setUserTrackingData($user_tracking_data);
    }

    /**
     * @inheritDoc
     */
    public function setTrafficData(ConnectionsModel $source_data)
    {
        $this->api_client->setTrafficSources($source_data);
    }

    /**
     * @inheritDoc
     */
    public function setCampaignData(ConnectionsModel $source_data)
    {
        $this->api_client->setCampaignData($source_data);
    }

    /**
     * @inheritDoc
     */
    public function setPurchaseData(OrderModel $order, array $order_products)
    {
        $this->api_client->setPurchaseData($order);

        foreach ($order_products as $order_product) {
            $this->setProductData($order_product);
        }
    }

    /**
     * @inheritDoc
     */
    public function setRefundData(OrderModel $order, array $order_products)
    {
        $this->api_client->setRefundData($order);

        foreach ($order_products as $order_product) {
            $this->setProductData($order_product);
        }
    }

    /**
     * @inheritDoc
     */
    public function setProductData(ProductModel $product)
    {
        $product_model = new GUAAPIProductModel($product);
        $this->api_client->addProduct($product_model);
    }

    /**
     * @inheritDoc
     */
    public function setEventData(string $category, string $action, string $label)
    {
        $this->api_client->setEvent($category, $action, $label);
    }

    /**
     * @inheritDoc
     */
    public function sendData()
    {
        $this->api_client->sendData();
    }
}
