<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\TrackingAPI\Components;

abstract class AbstractAPIComponent implements APIComponentInterface
{
    /**
     * @var array
     */
    protected $configuration;

    /**
     * @param array $configuration
     * @return bool
     */
    public function createAPIClient(array $configuration): bool
    {
        if ($this->isValidConfiguration($configuration)) {
            $this->setConfiguration($configuration);
            $this->setAPIClient();
            return true;
        }
        return false;
    }

    public function setConfiguration(array $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * @param array $configuration
     * @return bool
     */
    abstract protected function isValidConfiguration(array $configuration): bool;

    abstract protected function setAPIClient();
}
