<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\TrackingAPI\Components;

use RCPGTagManagerUserTrackingData;
use ReactionCode\RCPGTagManager\DataModel\Connections\ConnectionsModel;
use ReactionCode\RCPGTagManager\DataModel\Order\OrderModel;
use ReactionCode\RCPGTagManager\DataModel\Product\ProductModel;

interface APIComponentInterface
{
    /**
     * @param array $configuration
     * @return void
     */
    public function setConfiguration(array $configuration);

    /**
     * @param RCPGTagManagerUserTrackingData $user_tracking_data
     * @return void
     */
    public function setUserTrackingData(RCPGTagManagerUserTrackingData $user_tracking_data);

    /**
     * @param ConnectionsModel $source_data
     * @return void
     */
    public function setTrafficData(ConnectionsModel $source_data);

    /**
     * @param ConnectionsModel $source_data
     * @return void
     */
    public function setCampaignData(ConnectionsModel $source_data);

    /**
     * @param OrderModel $order
     * @param ProductModel[] $order_products
     * @return void
     */
    public function setPurchaseData(OrderModel $order, array $order_products);

    /**
     * @param OrderModel $order
     * @param ProductModel[] $order_products
     * @return void
     */
    public function setRefundData(OrderModel $order, array $order_products);

    /**
     * @param ProductModel $product
     * @return void
     */
    public function setProductData(ProductModel $product);

    /**
     * @param string $category
     * @param string $action
     * @param string $label
     * @return mixed
     */
    public function setEventData(string $category, string $action, string $label);

    /**
     * @return void
     */
    public function sendData();
}
