<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\TrackingAPI;

use ReactionCode\RCPGTagManager\PSModule\Configurator\ConfiguratorFactoryInterface;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;
use ReactionCode\RCPGTagManager\TrackingAPI\Components\APIComponentInterface;

class APIProvider implements APIProviderInterface
{
    /**
     * @var APIComponentInterface[]
     */
    private $available_apis = [];

    /**
     * @var APIFactory
     */
    private $tracking_api_factory;

    /**
     * @var ConfiguratorFactoryInterface
     */
    private $configurator_service;

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->tracking_api_factory = new APIFactory();
        $this->configurator_service = $module->getServiceProvider()->getConfiguratorService();
        $this->registerAPIS();
    }

    private function registerAPIS()
    {
        $this->initGUAAPI();
    }

    private function initGUAAPI()
    {
        $configuration = [
            'gua' => $this->configurator_service->getGUAConfiguration(),
            'gfeeds' => $this->configurator_service->getGFeedsConfiguration()
        ];

        $api = $this->tracking_api_factory->createGUAAPI();
        $this->setAPI($api, $configuration);
    }

    /**
     * @param APIComponentInterface $api
     * @param array $configuration
     */
    private function setAPI(APIComponentInterface $api, array $configuration)
    {
        if (empty($this->available_apis[get_class($api)])) {
            if ($api->createAPIClient($configuration)) {
                $this->available_apis[get_class($api)] = $api;
            }
        }
    }

    /**
     * @return APIComponentInterface[]
     */
    public function getAvailableAPIS(): array
    {
        return $this->available_apis;
    }
}
