<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Token;

use Configuration;
use Context;
use Exception;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

abstract class AbstractToken implements TokenInterface
{
    private $module;

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
    }

    /**
     * @return string
     */
    abstract public function getPublicToken(): string;

    protected function getPublicTokenSeed(): string
    {
        return $this->module->name .
            $this->module->version .
            Configuration::get('PS_SHOP_NAME')
        ;
    }

    /**
     * @param int $length
     * @return string|void
     * @throws Exception
     */
    public function createPrivateToken(int $length = 32)
    {
        if ($length <= 8) {
            $length = 32;
        }

        if (function_exists('random_bytes')) {
            return bin2hex(random_bytes($length));
        }

        if (function_exists('openssl_random_pseudo_bytes')) {
            return bin2hex(openssl_random_pseudo_bytes($length));
        }
    }
}
