<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Setup;

use Exception;
use PrestaShop\PrestaShop\Core\Addon\Module\ModuleManager;
use PrestaShop\PrestaShop\Core\Addon\Module\ModuleManagerBuilder;
use ReactionCode\RCPGTagManager\PSModule\Setup\DBTable\DBTableUserTrackingDataPS17;
use ReactionCode\RCPGTagManager\PSModule\Setup\DBTable\DBTableInterface;
use ReactionCode\RCPGTagManager\PSModule\Setup\DBTable\DBTableOrderTrackingStatusPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\HookFactoryPS17;

class SetupPS17 extends AbstractSetup
{
    private const OBSOLETE_VERSION = 'rc_pgtagmanager';

    /**
     * @return bool
     * @throws Exception
     */
    public function install(): bool
    {
        return parent::install() && $this->removeObsoleteVersion();
    }

    /**
     * @return DBTableInterface[]
     */
    protected function getTables(): array
    {
        return [
            new DBTableOrderTrackingStatusPS17(),
            new DBTableUserTrackingDataPS17()
        ];
    }

    /**
     * @return bool
     */
    protected function registerHooks(): bool
    {
        return $this->module->registerHook(HookFactoryPS17::HOOK_LIST);
    }

    /**
     * @return bool
     * @throws Exception
     */
    private static function removeObsoleteVersion(): bool
    {
        $result = true;
        $old_module = self::OBSOLETE_VERSION;
        $module_manager = self::getModuleManager();

        if ($module_manager instanceof ModuleManager && $module_manager->isInstalled($old_module)) {
            $result = $result && $module_manager->uninstall($old_module);
        }
        return $result && $module_manager->removeModuleFromDisk($old_module);
    }

    /**
     * @return ModuleManager|null
     */
    private static function getModuleManager(): ?ModuleManager
    {
        $module_builder = ModuleManagerBuilder::getInstance();
        if ($module_builder instanceof ModuleManagerBuilder) {
            return $module_builder->build();
        }
        return null;
    }
}
