<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Setup;

use ReactionCode\RCPGTagManager\PSModule\Setup\DBTable\DBTableUserTrackingDataPS16;
use ReactionCode\RCPGTagManager\PSModule\Setup\DBTable\DBTableInterface;
use ReactionCode\RCPGTagManager\PSModule\Setup\DBTable\DBTableOrderTrackingStatusPS16;
use ReactionCode\RCPGTagManager\PSModule\Hook\HookFactoryPS16;

class SetupPS16 extends AbstractSetup
{
    /**
     * @return DBTableInterface[]
     */
    protected function getTables(): array
    {
        return [
            new DBTableOrderTrackingStatusPS16(),
            new DBTableUserTrackingDataPS16()
        ];
    }

    /**
     * @return bool
     */
    protected function registerHooks(): bool
    {
        return $this->module->registerHook(HookFactoryPS16::HOOK_LIST);
    }
}
