<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Setup\DBTable;

use PrestaShopDatabaseException;
use RCPGTagManagerOrderTrackingStatus;

class DBTableOrderTrackingStatusPS17 extends AbstractDBTableOrderTrackingStatus
{
    private $old_table = 'rc_pgtagmanager_order_sent';

    /**
     * @return bool
     * @throws PrestaShopDatabaseException
     */
    public function install(): bool
    {
        $queries = [
            $this->getCreateTableQuery()
        ];

        if ($this->isOldTable()) {
            $queries[] = $this->getMigrationQuery();
        } else {
            $queries[] = $this->getInsertDataQuery();
        }

        return $this->executeQueries($queries);
    }

    /**
     * @return bool
     * @throws PrestaShopDatabaseException
     */
    private function isOldTable(): bool
    {
        $response = $this->db_instance->query($this->getOldTableQuery());
        return (bool)$response->rowCount();
    }

    /**
     * @return string
     */
    private function getOldTableQuery(): string
    {
        return 'SELECT `TABLE_NAME`
            FROM information_schema.TABLES
            WHERE `TABLE_NAME` = "'._DB_PREFIX_.$this->old_table.'"'
            ;
    }

    /**
     * @return string
     */
    private function getMigrationQuery(): string
    {
        return 'INSERT IGNORE INTO `'._DB_PREFIX_.$this->name.'`
            (id_order, status, date_add)
            SELECT
            `id_order`,
            CASE
                WHEN `sent_from` = "st" THEN '.RCPGTagManagerOrderTrackingStatus::SETUP.'
                WHEN `sent_from` = "fo" THEN '.RCPGTagManagerOrderTrackingStatus::CUSTOMER_BROWSER.'
                WHEN `sent_from` = "bo" THEN '.RCPGTagManagerOrderTrackingStatus::SERVER_CRON.'
            END AS status,
            `sent_at` AS date_add
            FROM `'._DB_PREFIX_.$this->old_table.'`'
            ;
    }
}
