<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Setup\DBTable;

use RCPGTagManagerUserTrackingData;

abstract class AbstractDBTableUserTrackingData extends AbstractDBTable
{
    /**
     * @return bool
     */
    public function install(): bool
    {
        $queries = [
            $this->getCreateTableQuery()
        ];

        return $this->executeQueries($queries);
    }

    protected function setTableName()
    {
        $this->name = RCPGTagManagerUserTrackingData::$definition['table'];
    }

    /**
     * @return string
     */
    protected function getCreateTableQuery(): string
    {
        return 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name.'`
            (
                `id_customer` INT(10) UNSIGNED NOT NULL,
                `ip` VARCHAR(39) NOT NULL,
                `uuid` VARCHAR(36) NOT NULL,
                `tracking_data` VARCHAR(21000) NULL,
                `date_add` DATETIME NOT NULL,
                PRIMARY KEY  (`id_customer`)
            )
            ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;'
        ;
    }
}
