<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Setup\DBTable;

use RCPGTagManagerOrderTrackingStatus;

abstract class AbstractDBTableOrderTrackingStatus extends AbstractDBTable
{
    protected function setTableName()
    {
        $this->name = RCPGTagManagerOrderTrackingStatus::$definition['table'];
    }

    protected function getCreateTableQuery(): string
    {
        return 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.$this->name.'` (
            `id_order` INT(10) UNSIGNED NOT NULL,
            `status` INT(2) UNSIGNED NOT NULL,
            `date_add` DATETIME NOT NULL,
            PRIMARY KEY  (`id_order`)
            ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8;'
            ;
    }

    protected function getInsertDataQuery(): string
    {
        return 'INSERT IGNORE INTO `'._DB_PREFIX_.$this->name.'` (id_order, status, date_add)
            SELECT
             `id_order`,
             "'.RCPGTagManagerOrderTrackingStatus::SETUP.'" AS `status`,
             `date_add`
            FROM `'._DB_PREFIX_.'orders`'
            ;
    }
}
