<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Setup\DBTable;

use Db;

abstract class AbstractDBTable implements DBTableInterface
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var Db
     */
    protected $db_instance;

    public function __construct()
    {
        $this->setTableName();
        $this->db_instance = Db::getInstance();
    }

    abstract protected function setTableName();

    public function uninstall(): bool
    {
        $queries = [
            $this->getDropTableQuery()
        ];

        return $this->executeQueries($queries);
    }

    protected function getDropTableQuery(): string
    {
        return 'DROP TABLE IF EXISTS `'._DB_PREFIX_.$this->name.'`';
    }

    /**
     * @param array $queries
     * @return bool
     */
    protected function executeQueries(array $queries): bool
    {
        foreach ($queries as $query) {
            if (!$this->db_instance->execute($query)) {
                return false;
            }
        }
        return true;
    }
}
