<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Setup;

use Module;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;
use ReactionCode\RCPGTagManager\PSModule\Setup\DBTable\DBTableInterface;
use ReactionCode\RCPGTagManager\PSModule\Form\FormHandler;

abstract class AbstractSetup implements SetupInterface
{
    /**
     * @var Module & RCTrackingModuleInterface
     */
    protected $module;

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
    }

    /**
     * @return bool
     */
    public function install(): bool
    {
        return $this->installTables() &&
            $this->registerHooks() &&
            $this->setDefaultConfiguration();
    }

    /**
     * @return bool
     */
    public function uninstall(): bool
    {
        return $this->uninstallTables();
    }

    /**
     * @return bool
     */
    protected function installTables(): bool
    {
        $tables = $this->getTables();
        $result = true;

        foreach ($tables as $table) {
            $result = $result && $table->install();
        }
        return $result;
    }

    /**
     * @return bool
     */
    protected function uninstallTables(): bool
    {
        $tables = $this->getTables();
        $result = true;

        foreach ($tables as $table) {
            $result = $result && $table->uninstall();
        }
        return $result;
    }

    /**
     * @return DBTableInterface[]
     */
    abstract protected function getTables(): array;

    /**
     * @return bool
     */
    abstract protected function registerHooks(): bool;

    /**
     * @return bool
     */
    protected function setDefaultConfiguration(): bool
    {
        $form_service = new FormHandler($this->module);
        return $form_service->setDefaultValues();
    }
}
