<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\OrderHandler\Validator;

use Order;

interface OrderValidatorInterface
{
    /**
     * @param Order $order
     * @return bool
     */
    public function isValidOrderComplete(Order $order): bool;

    /**
     * @param Order $order
     * @return bool
     */
    public function isValidOrderRefund(Order $order): bool;

    /**
     * @return bool
     */
    public function isWebOrder(): bool;

    /**
     * @return bool
     */
    public function isAdminOrder(): bool;

    /**
     * @return bool
     */
    public function isWebServiceOrder(): bool;
}
