<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\OrderHandler\Validator;

use AdminController;
use Context;
use Module;
use Order;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

abstract class AbstractOrderValidator implements OrderValidatorInterface
{
    /**
     * @var Module & RCTrackingModuleInterface
     */
    protected $module;

    /**
     * @var Context
     */
    protected $context;

    /**
     * @var array
     */
    protected $checkout_configuration;

    /**
     * @param RCTrackingModuleInterface $module
     */
    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
        $this->context = Context::getContext();
        $this->setCheckoutConfiguration();
    }

    private function setCheckoutConfiguration()
    {
        $configurator_service = $this->module->getServiceProvider()->getConfiguratorService();
        $this->checkout_configuration = $configurator_service->getCheckoutConfiguration();
    }

    /**
     * @param Order $order
     * @return bool
     */
    public function isValidOrderComplete(Order $order): bool
    {
        return !in_array($order->current_state, $this->checkout_configuration['invalid_order_statuses']);
    }

    /**
     * @param Order $order
     * @return bool
     */
    public function isValidOrderRefund(Order $order): bool
    {
        return in_array($order->current_state, $this->checkout_configuration['refund_order_statuses']);
    }

    public function isWebOrder(): bool
    {
        return !($this->isAdminOrder() || $this->isWebServiceOrder());
    }

    /**
     * @return bool
     */
    public function isAdminOrder(): bool
    {
        return $this->context->controller instanceof AdminController;
    }

    /**
     * @return bool
     */
    public function isWebServiceOrder(): bool
    {
        return !empty($GLOBALS['webservice_call']);
    }
}
