<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\OrderHandler\Fetcher;

use Order;
use PrestaShopDatabaseException;
use PrestaShopException;
use Tools;

class OrderFetcherPS17 extends AbstractOrderFetcher
{
    /**
     * @return Order|null
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function fetchOrder(): ?Order
    {
        return $this->module->getCurrentOrder() ?? $this->getOrderFromNonStandardModule();
    }

    /**
     * @return Order|null
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    private function getOrderFromNonStandardModule(): ?Order
    {
        $id_order = $this->getOrderIdFromURLParams() ?? $this->getOrderIdFromTemplate();
        return !empty($id_order) ? new Order($id_order) : null;
    }

    /**
     * @return int|null
     */
    private function getOrderIdFromURLParams(): ?int
    {
        $id_order = null;

        if (Tools::getValue('id_cart')) {
            $id_order = (int)$this->getOrderIdByCartId(Tools::getValue('id_cart'));
        }
        if (empty($id_order) && Tools::getValue('id_order')) {
            $id_order = (int)Tools::getValue('id_order');
        }
        return $id_order;
    }

    /**
     * @return int|null
     */
    private function getOrderIdFromTemplate(): ?int
    {
        $id_order = null;
        $template_vars = $this->context->smarty->getTemplateVars();

        if (!empty($template_vars['order'])) {
            if ($template_vars['order'] instanceof Order) {
                $id_order = (int)$template_vars['order']->id;
            } elseif (method_exists($template_vars['order'], 'getDetails')) {
                $id_order = (int)$template_vars['order']->getDetails()['id'];
            }
        } elseif (!empty($template_vars['id_order'])) {
            $id_order = (int)$template_vars['id_order'];
        } elseif (!empty($template_vars['id_cart'])) {
            $id_order = (int)$this->getOrderIdByCartId($template_vars['id_cart']);
        }
        return $id_order;
    }

    /**
     * @param $id_cart
     * @return false|int
     */
    private function getOrderIdByCartId($id_cart)
    {
        return method_exists('Order', 'getIdByCartId') ?
            Order::getIdByCartId($id_cart) :
            Order::getOrderByCartId($id_cart)
        ;
    }
}
