<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule;

use PrestaShopModuleException;

class ModuleServiceProvider
{
    /**
     * @param RCTrackingModuleInterface $module
     * @return ModuleServiceFactoryInterface
     * @throws PrestaShopModuleException
     */
    public static function getServicePlatform(RCTrackingModuleInterface $module)
    {
        switch ($module->getServiceVersion()) {
            case '16':
                return new ModuleServiceFactoryPS16($module);
            case '17':
                return new ModuleServiceFactoryPS17($module);
            default:
                throw new PrestaShopModuleException('PS version not compatible');
        }
    }
}
