<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule;

use ReactionCode\RCPGTagManager\PSModule\APIHandler\APIHandlerInterface;
use ReactionCode\RCPGTagManager\PSModule\APIHandler\APIHandlerPS16;
use ReactionCode\RCPGTagManager\PSModule\APIHandler\Components\Connections\OrderConnectionsInterface;
use ReactionCode\RCPGTagManager\PSModule\APIHandler\Components\Connections\OrderConnectionsPS16;
use ReactionCode\RCPGTagManager\PSModule\Content\ContentInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\DataModelHandler;
use ReactionCode\RCPGTagManager\PSModule\Adapter\Product\ProductAdapterPS16;
use ReactionCode\RCPGTagManager\PSModule\Content\ContentPS16;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\DataModelHandlerInterface;
use ReactionCode\RCPGTagManager\PSModule\Hook\HookFactoryInterface;
use ReactionCode\RCPGTagManager\PSModule\Hook\HookFactoryPS16;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\ModelBuilder\ModelBuilderFactoryPS16;
use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\ModuleDetectorInterface;
use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\ModuleDetectorPS16;
use ReactionCode\RCPGTagManager\PSModule\OrderHandler\Validator\OrderValidatorInterface;
use ReactionCode\RCPGTagManager\PSModule\OrderHandler\Validator\OrderValidatorPS16;
use ReactionCode\RCPGTagManager\PSModule\Setup\SetupInterface;
use ReactionCode\RCPGTagManager\PSModule\Setup\SetupPS16;
use ReactionCode\RCPGTagManager\PSModule\Token\TokenInterface;
use ReactionCode\RCPGTagManager\PSModule\Token\TokenPS16;

class ModuleServiceFactoryPS16 extends AbstractModuleServiceFactory
{
    /**
     * @inheritDoc
     */
    public function getSetupService(): SetupInterface
    {
        if (empty($this->services['setup'])) {
            $this->services['setup'] = new SetupPS16($this->module);
        }
        return $this->services['setup'];
    }

    /**
     * @inheritDoc
     */
    public function getContentService(): ContentInterface
    {
        if (empty($this->services['content'])) {
            $this->services['content'] = new ContentPS16($this->module);
        }
        return $this->services['content'];
    }

    /**
     * @inheritDoc
     */
    public function getHookService(): HookFactoryInterface
    {
        if (empty($this->services['hook_factory'])) {
            $this->services['hook_factory'] = new HookFactoryPS16($this->module);
        }
        return $this->services['hook_factory'];
    }

    /**
     * @inheritDoc
     */
    public function getDataModelService(): DataModelHandlerInterface
    {
        if (empty($this->services['data_model_handler'])) {
            $data_model_factory = new ModelBuilderFactoryPS16();
            $product_adapter = new ProductAdapterPS16();
            $this->services['data_model_handler'] = new DataModelHandler($data_model_factory, $product_adapter);
        }
        return $this->services['data_model_handler'];
    }


    /**
     * @inheritDoc
     */
    public function getModuleDetectorService(): ModuleDetectorInterface
    {
        if (empty($this->services['module_detector'])) {
            $this->services['module_detector'] = new ModuleDetectorPS16();
        }
        return $this->services['module_detector'];
    }

    /**
     * @inheritDoc
     */
    public function getOrderValidatorService(): OrderValidatorInterface
    {
        if (empty($this->services['order_validator'])) {
            $this->services['order_validator'] = new OrderValidatorPS16($this->module);
        }
        return $this->services['order_validator'];
    }

    /**
     * @inheritDoc
     */
    public function getAPIService(): APIHandlerInterface
    {
        if (empty($this->services['api_handler'])) {
            $this->services['api_handler'] = new APIHandlerPS16($this->module);
        }
        return $this->services['api_handler'];
    }

    /**
     * @inheritDoc
     */
    public function getTokenService(): TokenInterface
    {
        if (empty($this->services['token'])) {
            $this->services['token'] = new TokenPS16($this->module);
        }
        return $this->services['token'];
    }

    /**
     * @inheritDoc
     */
    public function getOrderConnectionsService(): OrderConnectionsInterface
    {
        if (empty($this->services['order_connections'])) {
            $this->services['order_connections'] = new OrderConnectionsPS16($this->module);
        }
        return $this->services['order_connections'];
    }
}
