<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule;

use ReactionCode\RCPGTagManager\PSModule\APIHandler\APIHandlerInterface;
use ReactionCode\RCPGTagManager\PSModule\APIHandler\Components\Connections\OrderConnectionsInterface;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\DataModelHandlerInterface;
use ReactionCode\RCPGTagManager\PSModule\Configurator\ConfiguratorFactoryInterface;
use ReactionCode\RCPGTagManager\PSModule\Content\ContentInterface;
use ReactionCode\RCPGTagManager\PSModule\Hook\HookFactoryInterface;
use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\ModuleDetectorInterface;
use ReactionCode\RCPGTagManager\PSModule\OrderHandler\Validator\OrderValidatorInterface;
use ReactionCode\RCPGTagManager\PSModule\Setup\SetupInterface;
use ReactionCode\RCPGTagManager\PSModule\Token\TokenInterface;

interface ModuleServiceFactoryInterface
{
    /**
     * @return SetupInterface
     */
    public function getSetupService(): SetupInterface;

    /**
     * @return ContentInterface
     */
    public function getContentService(): ContentInterface;

    /**
     * @return HookFactoryInterface
     */
    public function getHookService(): HookFactoryInterface;

    /**
     * @return DataModelHandlerInterface
     */
    public function getDataModelService(): DataModelHandlerInterface;

    /**
     * @return ModuleDetectorInterface
     */
    public function getModuleDetectorService(): ModuleDetectorInterface;

    /**
     * @return ConfiguratorFactoryInterface
     */
    public function getConfiguratorService(): ConfiguratorFactoryInterface;

    /**
     * @return OrderValidatorInterface
     */
    public function getOrderValidatorService(): OrderValidatorInterface;

    /**
     * @return APIHandlerInterface
     */
    public function getAPIService(): APIHandlerInterface;

    /**
     * @return TokenInterface
     */
    public function getTokenService(): TokenInterface;

    /**
     * @return OrderConnectionsInterface
     */
    public function getOrderConnectionsService(): OrderConnectionsInterface;
}
