<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector;

use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\ConcreteDetector\PresTeamShop\OnePageCheckoutPSPS16;

class OverrideDetectorPS16 extends AbstractOverrideDetector
{
    /**
     * @param array $checkout_module
     * @return false|OnePageCheckoutPSPS16
     */
    protected function getConcreteDetector(array $checkout_module)
    {
        switch ($checkout_module['module']) {
            case 'onepagecheckoutps':
                return new OnePageCheckoutPSPS16();
            default:
                return false;
        }
    }
}
