<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\ConcreteDetector\PresTeamShop;

use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\ConcreteDetector\AbstractConcreteDetector;

abstract class AbstractOnePageCheckoutPS extends AbstractConcreteDetector
{
    public function isCheckoutModule(array $checkout_module): bool
    {
        return property_exists($this->controller, 'opc') &&
            mb_strtolower(get_class($this->controller->opc)) === $checkout_module['module']
            ;
    }
}
