<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector;

use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\ConcreteDetector\ConcreteDetectorInterface;

abstract class AbstractOverrideDetector implements OverrideDetectorInterface
{
    /**
     * @param array $checkout_module
     * @return ConcreteDetectorInterface | false
     */
    abstract protected function getConcreteDetector(array $checkout_module);

    public function isCheckoutModule(array $checkout_module): bool
    {
        $concrete_detector = $this->getConcreteDetector($checkout_module);
        return $concrete_detector !== false && $concrete_detector->isCheckoutModule($checkout_module);
    }
}
