<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\ModuleDetector;

use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\AbstractOverrideDetector;
use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\OverrideDetectorPS17;

class ModuleDetectorPS17 extends AbstractModuleDetector
{
    /**
     * @return array
     */
    public function getCheckoutModules(): array
    {
        return [
            'list' => [
                [
                    'module' => 'sveacheckout',
                    'controller' => 'checkoutpage'
                ],
                [
                    'module' => 'klarnaofficial',
                    'controller' => 'checkoutklarnakco'
                ],
                [
                    'module' => 'pw_qlirocheckout',
                    'controller' => 'checkout'
                ],
                [
                    'module' => 'steasycheckout',
                    'controller' => 'default'
                ],
                [
                    'module' => 'thecheckout',
                    'controller' => 'order'
                ],
                // below are pending to verify
                [
                    'module' => 'onepagecheckoutps',
                    'controller' => 'order',
                    'has_override' => true,
                ],
                [
                    'module' => 'supercheckout',
                    'controller' => 'supercheckout'
                ]
            ],
            'default' => [
                'module' => 'default',
                'controller' => 'order',
            ]
        ];
    }

    protected function getOverrideDetector(): AbstractOverrideDetector
    {
        return new OverrideDetectorPS17();
    }
}
