<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\ModuleDetector;

use Configuration;
use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\AbstractOverrideDetector;
use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\OverrideDetectorPS16;

class ModuleDetectorPS16 extends AbstractModuleDetector
{
    /**
     * @return array
     */
    public function getCheckoutModules(): array
    {
        return [
            'list' => [
                [
                    'module' => 'onepagecheckoutps',
                    'controller' => 'orderopc',
                    'has_override' => true
                ],
                // below are pending to verify
                [
                    'module' => 'supercheckout',
                    'controller' => 'supercheckout'
                ],
                [
                    'module' => 'sveacheckout',
                    'controller' => 'sveapaypage'
                ],
                [
                    'module' => 'thecheckout',
                    'controller' => 'order'
                ],
                [
                    'module' => 'steasycheckout',
                    'controller' => 'default'
                ]
            ],
            'default' => [
                'module' => 'default',
                'controller' => (bool)Configuration::get('PS_ORDER_PROCESS_TYPE') ? 'orderopc' : 'order',
            ]
        ];
    }

    protected function getOverrideDetector(): AbstractOverrideDetector
    {
        return new OverrideDetectorPS16();
    }
}
