<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\ModuleDetector;

use Module;
use ReactionCode\RCPGTagManager\PSModule\ModuleDetector\OverrideDetector\AbstractOverrideDetector;
use Tools;

abstract class AbstractModuleDetector implements ModuleDetectorInterface
{
    protected $checkout_modules;

    public function __construct()
    {
        $this->checkout_modules = $this->getCheckoutModules();
    }

    /**
     * @return array
     */
    public function getCheckoutModule(): array
    {
        $checkout_module = $this->detectByModuleParam() ?: $this->detectByController();

        return $checkout_module ?: $this->checkout_modules['default'];
    }

    abstract protected function getCheckoutModules();

    /**
     * @return array | false
     */
    private function detectByModuleParam()
    {
        $module_name = Tools::getValue('module');

        if (!empty($module_name)) {
            $checkout_modules_names = array_column($this->checkout_modules['list'], 'module');
            $key = array_search($module_name, $checkout_modules_names, true);
            if ($key !== false) {
                return $this->checkout_modules['list'][$key];
            }
        }
        return false;
    }

    private function detectByController()
    {
        $checkout_modules = array_filter($this->checkout_modules['list'], [$this, 'filterModulesWithOverride']);
        $override_detector = $this->getOverrideDetector();

        foreach ($checkout_modules as $checkout_module) {
            if (Module::isEnabled($checkout_module['module']) &&
                $override_detector->isCheckoutModule($checkout_module)
            ) {
                return $checkout_module;
            }
        }
        return false;
    }

    /**
     * @param $module
     * @return bool
     */
    private function filterModulesWithOverride($module): bool
    {
        return array_key_exists('has_override', $module);
    }

    abstract protected function getOverrideDetector(): AbstractOverrideDetector;
}
