<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Hook;

use ReactionCode\RCPGTagManager\PSModule\Hook\ActionAuthentication\ActionAuthenticationPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\ActionCustomerAccountAdd\ActionCustomerAccountAddPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\ActionValidateOrder\ActionValidateOrderPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderContentOrder\DisplayAdminOrderContentOrderPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderTabContent\DisplayAdminOrderTabContentPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderTabLink\DisplayAdminOrderTabLinkPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\AdminOrderView\DisplayAdminOrderTabOrder\DisplayAdminOrderTabOrderPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\DisplayBackOfficeHeader\DisplayBackOfficeHeaderPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\DisplayBeforeBodyClosingTag\DisplayBeforeBodyClosingTagPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\DisplayOrderConfirmation\DisplayOrderConfirmationPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\DisplayPaymentReturn\DisplayPaymentReturnPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\Header\HeaderPS17;
use ReactionCode\RCPGTagManager\PSModule\Hook\ActionOrderStatusUpdate\ActionOrderStatusUpdatePS17;

class HookFactoryPS17 extends AbstractHookFactory
{
    const HOOK_LIST = [
        'header',
        'displayPaymentReturn',
        'displayOrderConfirmation',
        'displayBeforeBodyClosingTag',
        'displayBackOfficeHeader',
        'displayAdminOrderTabOrder',
        'displayAdminOrderContentOrder',
        'displayAdminOrderTabLink',
        'displayAdminOrderTabContent',
        'actionValidateOrder',
        'actionOrderStatusUpdate',
        'actionCustomerAccountAdd',
        'actionAuthentication'
    ];

    /**
     * @return HookInterface
     */
    protected function createHeader()
    {
        return new HeaderPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createDisplayPaymentReturn()
    {
        return new DisplayPaymentReturnPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    public function createDisplayOrderConfirmation()
    {
        return new DisplayOrderConfirmationPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createDisplayBeforeBodyClosingTag()
    {
        return new DisplayBeforeBodyClosingTagPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createDisplayBackOfficeHeader()
    {
        return new DisplayBackOfficeHeaderPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createDisplayAdminOrderTabOrder()
    {
        return new DisplayAdminOrderTabOrderPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createDisplayAdminOrderContentOrder()
    {
        return new DisplayAdminOrderContentOrderPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createDisplayAdminOrderTabLink()
    {
        return new DisplayAdminOrderTabLinkPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createDisplayAdminOrderTabContent()
    {
        return new DisplayAdminOrderTabContentPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createActionValidateOrder()
    {
        return new ActionValidateOrderPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createActionOrderStatusUpdate()
    {
        return new ActionOrderStatusUpdatePS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createActionCustomerAccountAdd()
    {
        return new ActionCustomerAccountAddPS17($this->module);
    }

    /**
     * @return HookInterface
     */
    protected function createActionAuthentication()
    {
        return new ActionAuthenticationPS17($this->module);
    }
}
